/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Request;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestRequest
extends BaseRequest<Request> {
    public RequestRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<? extends Request> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public RequestRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Request.class);
    }

    @Nonnull
    public CompletableFuture<Request> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Request get() throws ClientException {
        return (Request)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Request> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Request delete() throws ClientException {
        return (Request)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Request> patchAsync(@Nonnull Request sourceRequest) {
        return this.sendAsync(HttpMethod.PATCH, sourceRequest);
    }

    @Nullable
    public Request patch(@Nonnull Request sourceRequest) throws ClientException {
        return (Request)this.send(HttpMethod.PATCH, sourceRequest);
    }

    @Nonnull
    public CompletableFuture<Request> postAsync(@Nonnull Request newRequest) {
        return this.sendAsync(HttpMethod.POST, newRequest);
    }

    @Nullable
    public Request post(@Nonnull Request newRequest) throws ClientException {
        return (Request)this.send(HttpMethod.POST, newRequest);
    }

    @Nonnull
    public CompletableFuture<Request> putAsync(@Nonnull Request newRequest) {
        return this.sendAsync(HttpMethod.PUT, newRequest);
    }

    @Nullable
    public Request put(@Nonnull Request newRequest) throws ClientException {
        return (Request)this.send(HttpMethod.PUT, newRequest);
    }

    @Nonnull
    public RequestRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public RequestRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

