/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.IntelligenceProfile;
import com.microsoft.graph.security.requests.IntelligenceProfileCollectionPage;
import com.microsoft.graph.security.requests.IntelligenceProfileCollectionRequestBuilder;
import com.microsoft.graph.security.requests.IntelligenceProfileCollectionResponse;
import com.microsoft.graph.security.requests.IntelligenceProfileRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntelligenceProfileCollectionRequest
extends BaseEntityCollectionRequest<IntelligenceProfile, IntelligenceProfileCollectionResponse, IntelligenceProfileCollectionPage> {
    public IntelligenceProfileCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IntelligenceProfileCollectionResponse.class, IntelligenceProfileCollectionPage.class, IntelligenceProfileCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<IntelligenceProfile> postAsync(@Nonnull IntelligenceProfile newIntelligenceProfile) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IntelligenceProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newIntelligenceProfile);
    }

    @Nonnull
    public IntelligenceProfile post(@Nonnull IntelligenceProfile newIntelligenceProfile) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IntelligenceProfileRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIntelligenceProfile);
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public IntelligenceProfileCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

