/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests;

import com.microsoft.graph.callrecords.models.Segment;
import com.microsoft.graph.callrecords.requests.SegmentCollectionPage;
import com.microsoft.graph.callrecords.requests.SegmentCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.SegmentCollectionResponse;
import com.microsoft.graph.callrecords.requests.SegmentRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SegmentCollectionRequest
extends BaseEntityCollectionRequest<Segment, SegmentCollectionResponse, SegmentCollectionPage> {
    public SegmentCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SegmentCollectionResponse.class, SegmentCollectionPage.class, SegmentCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Segment> postAsync(@Nonnull Segment newSegment) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SegmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newSegment);
    }

    @Nonnull
    public Segment post(@Nonnull Segment newSegment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SegmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSegment);
    }

    @Nonnull
    public SegmentCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public SegmentCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

