/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Call;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CallRequest
extends BaseRequest<Call> {
    public CallRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Call.class);
    }

    @Nonnull
    public CompletableFuture<Call> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Call get() throws ClientException {
        return (Call)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Call> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Call delete() throws ClientException {
        return (Call)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Call> patchAsync(@Nonnull Call sourceCall) {
        return this.sendAsync(HttpMethod.PATCH, sourceCall);
    }

    @Nullable
    public Call patch(@Nonnull Call sourceCall) throws ClientException {
        return (Call)this.send(HttpMethod.PATCH, sourceCall);
    }

    @Nonnull
    public CompletableFuture<Call> postAsync(@Nonnull Call newCall) {
        return this.sendAsync(HttpMethod.POST, newCall);
    }

    @Nullable
    public Call post(@Nonnull Call newCall) throws ClientException {
        return (Call)this.send(HttpMethod.POST, newCall);
    }

    @Nonnull
    public CompletableFuture<Call> putAsync(@Nonnull Call newCall) {
        return this.sendAsync(HttpMethod.PUT, newCall);
    }

    @Nullable
    public Call put(@Nonnull Call newCall) throws ClientException {
        return (Call)this.send(HttpMethod.PUT, newCall);
    }

    @Nonnull
    public CallRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CallRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

