/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.DirectoryRole;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryRoleRequest
extends BaseRequest<DirectoryRole> {
    public DirectoryRoleRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryRole.class);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DirectoryRole get() throws ClientException {
        return (DirectoryRole)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DirectoryRole delete() throws ClientException {
        return (DirectoryRole)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> patchAsync(@Nonnull DirectoryRole sourceDirectoryRole) {
        return this.sendAsync(HttpMethod.PATCH, sourceDirectoryRole);
    }

    @Nullable
    public DirectoryRole patch(@Nonnull DirectoryRole sourceDirectoryRole) throws ClientException {
        return (DirectoryRole)this.send(HttpMethod.PATCH, sourceDirectoryRole);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> postAsync(@Nonnull DirectoryRole newDirectoryRole) {
        return this.sendAsync(HttpMethod.POST, newDirectoryRole);
    }

    @Nullable
    public DirectoryRole post(@Nonnull DirectoryRole newDirectoryRole) throws ClientException {
        return (DirectoryRole)this.send(HttpMethod.POST, newDirectoryRole);
    }

    @Nonnull
    public CompletableFuture<DirectoryRole> putAsync(@Nonnull DirectoryRole newDirectoryRole) {
        return this.sendAsync(HttpMethod.PUT, newDirectoryRole);
    }

    @Nullable
    public DirectoryRole put(@Nonnull DirectoryRole newDirectoryRole) throws ClientException {
        return (DirectoryRole)this.send(HttpMethod.PUT, newDirectoryRole);
    }

    @Nonnull
    public DirectoryRoleRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DirectoryRoleRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

