/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.OAuth2PermissionGrant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionWithReferencesPage;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionWithReferencesRequest;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.OAuth2PermissionGrantReferenceRequestBuilder;
import com.microsoft.graph.requests.OAuth2PermissionGrantWithReferenceRequest;
import com.microsoft.graph.requests.OAuth2PermissionGrantWithReferenceRequestBuilder;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuth2PermissionGrantCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<OAuth2PermissionGrant, OAuth2PermissionGrantWithReferenceRequest, OAuth2PermissionGrantReferenceRequestBuilder, OAuth2PermissionGrantWithReferenceRequestBuilder, OAuth2PermissionGrantCollectionResponse, OAuth2PermissionGrantCollectionWithReferencesPage, OAuth2PermissionGrantCollectionWithReferencesRequest> {
    public OAuth2PermissionGrantCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantCollectionResponse.class, OAuth2PermissionGrantCollectionWithReferencesPage.class, OAuth2PermissionGrantCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<OAuth2PermissionGrant> postAsync(@Nonnull OAuth2PermissionGrant newOAuth2PermissionGrant) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/oauth2PermissionGrants/" + newOAuth2PermissionGrant.id);
        return ((OAuth2PermissionGrantWithReferenceRequest)new OAuth2PermissionGrantWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newOAuth2PermissionGrant, (IJsonBackedObject)body);
    }

    @Nonnull
    public OAuth2PermissionGrant post(@Nonnull OAuth2PermissionGrant newOAuth2PermissionGrant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/oauth2PermissionGrants/" + newOAuth2PermissionGrant.id);
        return (OAuth2PermissionGrant)((OAuth2PermissionGrantWithReferenceRequest)new OAuth2PermissionGrantWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newOAuth2PermissionGrant, (IJsonBackedObject)body);
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

