/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.OAuth2PermissionGrant;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OAuth2PermissionGrantReferenceRequest
extends BaseReferenceRequest<OAuth2PermissionGrant> {
    public OAuth2PermissionGrantReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrant.class);
    }

    @Nonnull
    public OAuth2PermissionGrantReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public OAuth2PermissionGrantReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<OAuth2PermissionGrant> putAsync(@Nonnull OAuth2PermissionGrant srcOAuth2PermissionGrant) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/oauth2PermissionGrants/" + srcOAuth2PermissionGrant.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public OAuth2PermissionGrant put(@Nonnull OAuth2PermissionGrant srcOAuth2PermissionGrant) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/oauth2PermissionGrants/" + srcOAuth2PermissionGrant.id));
        return (OAuth2PermissionGrant)this.send(HttpMethod.PUT, payload);
    }
}

