/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ResourceOperation;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceOperationRequest
extends BaseRequest<ResourceOperation> {
    public ResourceOperationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceOperation.class);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ResourceOperation get() throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ResourceOperation delete() throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> patchAsync(@Nonnull ResourceOperation sourceResourceOperation) {
        return this.sendAsync(HttpMethod.PATCH, sourceResourceOperation);
    }

    @Nullable
    public ResourceOperation patch(@Nonnull ResourceOperation sourceResourceOperation) throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.PATCH, sourceResourceOperation);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> postAsync(@Nonnull ResourceOperation newResourceOperation) {
        return this.sendAsync(HttpMethod.POST, newResourceOperation);
    }

    @Nullable
    public ResourceOperation post(@Nonnull ResourceOperation newResourceOperation) throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.POST, newResourceOperation);
    }

    @Nonnull
    public CompletableFuture<ResourceOperation> putAsync(@Nonnull ResourceOperation newResourceOperation) {
        return this.sendAsync(HttpMethod.PUT, newResourceOperation);
    }

    @Nullable
    public ResourceOperation put(@Nonnull ResourceOperation newResourceOperation) throws ClientException {
        return (ResourceOperation)this.send(HttpMethod.PUT, newResourceOperation);
    }

    @Nonnull
    public ResourceOperationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ResourceOperationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

