/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostPair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostPairReferenceRequest
extends BaseReferenceRequest<HostPair> {
    public HostPairReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPair.class);
    }

    @Nonnull
    public HostPairReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostPairReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<HostPair> putAsync(@Nonnull HostPair srcHostPair) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/host/{id}/childHostPairs/" + srcHostPair.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public HostPair put(@Nonnull HostPair srcHostPair) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/host/{id}/childHostPairs/" + srcHostPair.id));
        return (HostPair)this.send(HttpMethod.PUT, payload);
    }
}

