/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.externalconnectors.models.ConnectionOperation;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConnectionOperationRequest
extends BaseRequest<ConnectionOperation> {
    public ConnectionOperationRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConnectionOperation.class);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ConnectionOperation get() throws ClientException {
        return (ConnectionOperation)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ConnectionOperation delete() throws ClientException {
        return (ConnectionOperation)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> patchAsync(@Nonnull ConnectionOperation sourceConnectionOperation) {
        return this.sendAsync(HttpMethod.PATCH, sourceConnectionOperation);
    }

    @Nullable
    public ConnectionOperation patch(@Nonnull ConnectionOperation sourceConnectionOperation) throws ClientException {
        return (ConnectionOperation)this.send(HttpMethod.PATCH, sourceConnectionOperation);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> postAsync(@Nonnull ConnectionOperation newConnectionOperation) {
        return this.sendAsync(HttpMethod.POST, newConnectionOperation);
    }

    @Nullable
    public ConnectionOperation post(@Nonnull ConnectionOperation newConnectionOperation) throws ClientException {
        return (ConnectionOperation)this.send(HttpMethod.POST, newConnectionOperation);
    }

    @Nonnull
    public CompletableFuture<ConnectionOperation> putAsync(@Nonnull ConnectionOperation newConnectionOperation) {
        return this.sendAsync(HttpMethod.PUT, newConnectionOperation);
    }

    @Nullable
    public ConnectionOperation put(@Nonnull ConnectionOperation newConnectionOperation) throws ClientException {
        return (ConnectionOperation)this.send(HttpMethod.PUT, newConnectionOperation);
    }

    @Nonnull
    public ConnectionOperationRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConnectionOperationRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

