/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.Task;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionPage;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.TaskCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.TaskRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TaskCollectionRequest
extends BaseEntityCollectionRequest<Task, TaskCollectionResponse, TaskCollectionPage> {
    public TaskCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskCollectionResponse.class, TaskCollectionPage.class, TaskCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Task> postAsync(@Nonnull Task newTask) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newTask);
    }

    @Nonnull
    public Task post(@Nonnull Task newTask) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TaskRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTask);
    }

    @Nonnull
    public TaskCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public TaskCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

