/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.identitygovernance.models.WorkflowVersion;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowVersionRequest
extends BaseRequest<WorkflowVersion> {
    public WorkflowVersionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowVersion.class);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public WorkflowVersion get() throws ClientException {
        return (WorkflowVersion)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public WorkflowVersion delete() throws ClientException {
        return (WorkflowVersion)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> patchAsync(@Nonnull WorkflowVersion sourceWorkflowVersion) {
        return this.sendAsync(HttpMethod.PATCH, sourceWorkflowVersion);
    }

    @Nullable
    public WorkflowVersion patch(@Nonnull WorkflowVersion sourceWorkflowVersion) throws ClientException {
        return (WorkflowVersion)this.send(HttpMethod.PATCH, sourceWorkflowVersion);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> postAsync(@Nonnull WorkflowVersion newWorkflowVersion) {
        return this.sendAsync(HttpMethod.POST, newWorkflowVersion);
    }

    @Nullable
    public WorkflowVersion post(@Nonnull WorkflowVersion newWorkflowVersion) throws ClientException {
        return (WorkflowVersion)this.send(HttpMethod.POST, newWorkflowVersion);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> putAsync(@Nonnull WorkflowVersion newWorkflowVersion) {
        return this.sendAsync(HttpMethod.PUT, newWorkflowVersion);
    }

    @Nullable
    public WorkflowVersion put(@Nonnull WorkflowVersion newWorkflowVersion) throws ClientException {
        return (WorkflowVersion)this.send(HttpMethod.PUT, newWorkflowVersion);
    }

    @Nonnull
    public WorkflowVersionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

