/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ConditionalAccessPolicy;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConditionalAccessPolicyReferenceRequest
extends BaseReferenceRequest<ConditionalAccessPolicy> {
    public ConditionalAccessPolicyReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConditionalAccessPolicy.class);
    }

    @Nonnull
    public ConditionalAccessPolicyReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ConditionalAccessPolicyReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<ConditionalAccessPolicy> putAsync(@Nonnull ConditionalAccessPolicy srcConditionalAccessPolicy) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/mfa/" + srcConditionalAccessPolicy.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public ConditionalAccessPolicy put(@Nonnull ConditionalAccessPolicy srcConditionalAccessPolicy) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/mfa/" + srcConditionalAccessPolicy.id));
        return (ConditionalAccessPolicy)this.send(HttpMethod.PUT, payload);
    }
}

