/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.models.WorkbookChart;
import com.microsoft.graph.models.WorkbookChartItemParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.WorkbookChartAreaFormatRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartAxesRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartDataLabelsRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartItemRequest;
import com.microsoft.graph.requests.WorkbookChartLegendRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartSeriesCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartSeriesRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartTitleRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkbookChartItemRequestBuilder
extends BaseFunctionRequestBuilder<WorkbookChart> {
    public WorkbookChartItemRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public WorkbookChartItemRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull WorkbookChartItemParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        if (parameters != null) {
            this.functionOptions = parameters.getFunctionOptions();
        }
    }

    @Nonnull
    public WorkbookChartItemRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public WorkbookChartItemRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        WorkbookChartItemRequest request = new WorkbookChartItemRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        for (FunctionOption option : this.functionOptions) {
            request.addFunctionOption(option);
        }
        return request;
    }

    @Nonnull
    public WorkbookChartAxesRequestBuilder axes() {
        return new WorkbookChartAxesRequestBuilder(this.getRequestUrlWithAdditionalSegment("axes"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartDataLabelsRequestBuilder dataLabels() {
        return new WorkbookChartDataLabelsRequestBuilder(this.getRequestUrlWithAdditionalSegment("dataLabels"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartAreaFormatRequestBuilder format() {
        return new WorkbookChartAreaFormatRequestBuilder(this.getRequestUrlWithAdditionalSegment("format"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartLegendRequestBuilder legend() {
        return new WorkbookChartLegendRequestBuilder(this.getRequestUrlWithAdditionalSegment("legend"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartSeriesCollectionRequestBuilder series() {
        return new WorkbookChartSeriesCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("series"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartSeriesRequestBuilder series(@Nonnull String id) {
        return new WorkbookChartSeriesRequestBuilder(this.getRequestUrlWithAdditionalSegment("series") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public WorkbookChartTitleRequestBuilder title() {
        return new WorkbookChartTitleRequestBuilder(this.getRequestUrlWithAdditionalSegment("title"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookWorksheetRequestBuilder worksheet() {
        return new WorkbookWorksheetRequestBuilder(this.getRequestUrlWithAdditionalSegment("worksheet"), this.getClient(), null);
    }
}

