/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Article;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArticleRequest
extends BaseRequest<Article> {
    public ArticleRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Article.class);
    }

    @Nonnull
    public CompletableFuture<Article> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Article get() throws ClientException {
        return (Article)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Article> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Article delete() throws ClientException {
        return (Article)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Article> patchAsync(@Nonnull Article sourceArticle) {
        return this.sendAsync(HttpMethod.PATCH, sourceArticle);
    }

    @Nullable
    public Article patch(@Nonnull Article sourceArticle) throws ClientException {
        return (Article)this.send(HttpMethod.PATCH, sourceArticle);
    }

    @Nonnull
    public CompletableFuture<Article> postAsync(@Nonnull Article newArticle) {
        return this.sendAsync(HttpMethod.POST, newArticle);
    }

    @Nullable
    public Article post(@Nonnull Article newArticle) throws ClientException {
        return (Article)this.send(HttpMethod.POST, newArticle);
    }

    @Nonnull
    public CompletableFuture<Article> putAsync(@Nonnull Article newArticle) {
        return this.sendAsync(HttpMethod.PUT, newArticle);
    }

    @Nullable
    public Article put(@Nonnull Article newArticle) throws ClientException {
        return (Article)this.send(HttpMethod.PUT, newArticle);
    }

    @Nonnull
    public ArticleRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ArticleRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

