/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.Compatibility;
import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.ParametersNameDecodingOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ParametersNameDecodingHandler
implements Interceptor {
    private final ParametersNameDecodingOption options;

    public ParametersNameDecodingHandler() {
        this(new ParametersNameDecodingOption());
    }

    public ParametersNameDecodingHandler(@Nonnull ParametersNameDecodingOption options) {
        this.options = Objects.requireNonNull(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain);
        Request request = chain.request();
        ParametersNameDecodingOption nameOption = (ParametersNameDecodingOption)request.tag(ParametersNameDecodingOption.class);
        if (nameOption == null) {
            nameOption = this.options;
        }
        HttpUrl originalUri = request.url();
        Span span = ObservabilityHelper.getSpanForRequest(request, "ParametersNameDecodingHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.parameters_name_decoding.enable", nameOption.enable);
        }
        try {
            if (!originalUri.toString().contains("%") || nameOption == null || !nameOption.enable || nameOption.parametersToDecode == null || nameOption.parametersToDecode.length == 0) {
                Response response = chain.proceed(request);
                return response;
            }
            String query = originalUri.encodedQuery();
            if (query == null || query.isEmpty()) {
                Response response = chain.proceed(request);
                return response;
            }
            query = ParametersNameDecodingHandler.decodeQueryParameters(query, nameOption.parametersToDecode);
            Request.Builder builder = request.newBuilder();
            if (span != null) {
                builder.tag(Span.class, (Object)span);
            }
            HttpUrl newUrl = originalUri.newBuilder().encodedQuery(query).build();
            Response response = chain.proceed(builder.url(newUrl).build());
            return response;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
    }

    @Nonnull
    public static String decodeQueryParameters(@Nullable String original, @Nonnull char[] charactersToDecode) {
        Objects.requireNonNull(charactersToDecode);
        if (original == null || Compatibility.isBlank((String)original) || charactersToDecode.length == 0) {
            return "";
        }
        String[] encodedQueryParameters = (original.startsWith("?") ? original.substring(1) : original).split("&");
        ArrayList<AbstractMap.SimpleEntry<String, String>> toDecode = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        for (String encodedQueryParameter : encodedQueryParameters) {
            String[] stringArray = encodedQueryParameter.split("=", 2);
            toDecode.add(new AbstractMap.SimpleEntry<String, String>(stringArray.length > 1 ? stringArray[1] : "", stringArray[0]));
        }
        ArrayList<AbstractMap.SimpleEntry<String, String>> symbolsToReplace = new ArrayList<AbstractMap.SimpleEntry<String, String>>(charactersToDecode.length);
        for (char c : charactersToDecode) {
            symbolsToReplace.add(new AbstractMap.SimpleEntry<String, String>("%" + String.format("%x", c), String.valueOf(c)));
        }
        Object object = symbolsToReplace.iterator();
        while (object.hasNext()) {
            Map.Entry symbolToReplace = (Map.Entry)object.next();
            for (Map.Entry entry : toDecode) {
                entry.setValue(((String)entry.getValue()).replaceAll("(?i)" + Pattern.quote((String)symbolToReplace.getKey()), Matcher.quoteReplacement((String)symbolToReplace.getValue())));
            }
        }
        return toDecode.stream().map(tuple -> Compatibility.isBlank((String)((String)tuple.getKey())) ? (String)tuple.getValue() : (String)tuple.getValue() + "=" + (String)tuple.getKey()).collect(Collectors.joining("&"));
    }
}

