/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware.options;

import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.http.middleware.options.IShouldRetry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class RetryHandlerOption
implements RequestOption {
    @Nonnull
    private final IShouldRetry mShouldRetry;
    @Nonnull
    public static final IShouldRetry DEFAULT_SHOULD_RETRY = (delay, executionCount, request, response) -> true;
    private int mMaxRetries;
    public static final int MAX_RETRIES = 10;
    public static final int DEFAULT_MAX_RETRIES = 3;
    private long mDelay;
    public static final long DEFAULT_DELAY = 3L;
    public static final long MAX_DELAY = 180L;

    public RetryHandlerOption() {
        this(DEFAULT_SHOULD_RETRY, 3, 3L);
    }

    public RetryHandlerOption(@Nullable IShouldRetry shouldRetry, int maxRetries, long delay) {
        if (delay > 180L) {
            throw new IllegalArgumentException("Delay cannot exceed 180");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay cannot be negative");
        }
        if (maxRetries > 10) {
            throw new IllegalArgumentException("Max retries cannot exceed 10");
        }
        if (maxRetries < 0) {
            throw new IllegalArgumentException("Max retries cannot be negative");
        }
        this.mShouldRetry = shouldRetry == null ? DEFAULT_SHOULD_RETRY : shouldRetry;
        this.mMaxRetries = maxRetries;
        this.mDelay = delay;
    }

    @Nonnull
    public IShouldRetry shouldRetry() {
        return this.mShouldRetry;
    }

    public int maxRetries() {
        return this.mMaxRetries;
    }

    public long delay() {
        return this.mDelay;
    }

    @Nonnull
    public <T extends RequestOption> Class<T> getType() {
        return RetryHandlerOption.class;
    }
}

