/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class Validator {
    private Validator() {
    }

    public static void validate(Object parameter) {
        if (parameter == null) {
            return;
        }
        Class<Object> type = parameter.getClass();
        if (type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class) {
            type = Validator.wrapperToPrimitive(type);
        }
        if (type.isPrimitive() || type.isEnum() || type.isAssignableFrom(Class.class) || type.isAssignableFrom(LocalDate.class) || type.isAssignableFrom(OffsetDateTime.class) || type.isAssignableFrom(String.class) || type.isAssignableFrom(DateTimeRfc1123.class) || type.isAssignableFrom(Duration.class)) {
            return;
        }
        for (Class<Object> clazz : TypeUtil.getAllClasses(type)) {
            if (clazz.isAssignableFrom(Object.class)) continue;
            for (Field field : clazz.getDeclaredFields()) {
                Object property;
                JsonProperty annotation;
                field.setAccessible(true);
                int mod = field.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || (annotation = field.getAnnotation(JsonProperty.class)) != null && annotation.access().equals((Object)JsonProperty.Access.WRITE_ONLY)) continue;
                try {
                    property = field.get(parameter);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                if (property == null) {
                    if (annotation == null || !annotation.required()) continue;
                    throw new IllegalArgumentException(field.getName() + " is required and cannot be null.");
                }
                try {
                    Class<?> propertyType = property.getClass();
                    if (List.class.isAssignableFrom(propertyType)) {
                        List items = (List)property;
                        for (Object e : items) {
                            Validator.validate(e);
                        }
                        continue;
                    }
                    if (Map.class.isAssignableFrom(propertyType)) {
                        Map entries = (Map)property;
                        for (Map.Entry entry : entries.entrySet()) {
                            Validator.validate(entry.getKey());
                            Validator.validate(entry.getValue());
                        }
                        continue;
                    }
                    if (type == propertyType) continue;
                    Validator.validate(property);
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getCause() == null) {
                        throw new IllegalArgumentException(field.getName() + "." + ex.getMessage());
                    }
                    throw ex;
                }
            }
        }
    }

    private static Class<?> wrapperToPrimitive(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return clazz;
    }
}

