/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentMultiHashMap<K, V> {
    private final Map<K, ConcurrentLinkedQueue<V>> data = Collections.synchronizedMap(new LinkedHashMap(16, 0.75f, true));
    private final AtomicInteger size = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            if (!this.data.containsKey(key)) {
                this.data.put(key, new ConcurrentLinkedQueue());
            }
            this.data.get(key).add(value);
            this.size.incrementAndGet();
            return value;
        }
    }

    public ConcurrentLinkedQueue<V> get(K key) {
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll() {
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            K key;
            if (this.size.get() == 0) {
                return null;
            }
            Map<K, ConcurrentLinkedQueue<V>> map = this.data;
            synchronized (map) {
                Iterator<K> keys = this.data.keySet().iterator();
                key = keys.next();
            }
            return this.poll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V poll(K key) {
        V ret;
        if (!this.data.containsKey(key)) {
            return null;
        }
        ConcurrentLinkedQueue<V> queue = this.data.get(key);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            this.size.decrementAndGet();
            ret = queue.poll();
        }
        if (queue.isEmpty()) {
            this.data.remove(key);
        }
        return ret;
    }

    public int size() {
        return this.size.get();
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key) && this.data.get(key).size() > 0;
    }

    public Set<K> keys() {
        HashSet<K> keys = new HashSet<K>();
        for (K key : this.data.keySet()) {
            if (this.data.get(key).size() <= 0) continue;
            keys.add(key);
        }
        return keys;
    }

    public Set<V> values() {
        HashSet values = new HashSet();
        for (K k : this.keys()) {
            values.addAll(this.data.get(k));
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key, V value) {
        boolean removed;
        if (!this.data.containsKey(key)) {
            return false;
        }
        ConcurrentLinkedQueue<V> queue = this.data.get(key);
        AtomicInteger atomicInteger = this.size;
        synchronized (atomicInteger) {
            this.size.decrementAndGet();
            removed = queue.remove(value);
        }
        if (queue.isEmpty()) {
            this.data.remove(key);
        }
        return removed;
    }
}

