/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.http;

import com.microsoft.rest.v2.http.ConcurrentMultiHashMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLException;

class SharedChannelPool
implements ChannelPool {
    private static final AttributeKey<URI> CHANNEL_URI = AttributeKey.newInstance((String)"channel-uri");
    private final Bootstrap bootstrap;
    private final ChannelPoolHandler handler;
    private final int poolSize;
    private final Queue<ChannelRequest> requests;
    private final ConcurrentMultiHashMap<URI, Channel> available;
    private final ConcurrentMultiHashMap<URI, Channel> leased;
    private final Object sync = new Object();
    private final SslContext sslContext;
    private final ExecutorService executor;
    private volatile boolean closed = false;

    private static boolean isChannelHealthy(Channel channel) {
        if (!channel.isActive()) {
            return false;
        }
        return channel.pipeline().get("HttpResponseDecoder") != null || channel.pipeline().get("HttpClientCodec") != null;
    }

    SharedChannelPool(Bootstrap bootstrap, final ChannelPoolHandler handler, int size) {
        this.bootstrap = (Bootstrap)bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                assert (ch.eventLoop().inEventLoop());
                handler.channelCreated(ch);
            }
        });
        this.handler = handler;
        this.poolSize = size;
        this.requests = new ConcurrentLinkedDeque<ChannelRequest>();
        this.available = new ConcurrentMultiHashMap();
        this.leased = new ConcurrentMultiHashMap();
        try {
            this.sslContext = SslContextBuilder.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "SharedChannelPool-worker");
            thread.setDaemon(true);
            return thread;
        });
        this.executor.submit(() -> {
            while (!this.closed) {
                try {
                    Object object = this.requests;
                    synchronized (object) {
                        while (this.requests.isEmpty() && !this.closed) {
                            this.requests.wait();
                        }
                    }
                    ChannelRequest request = this.requests.remove();
                    object = this.sync;
                    synchronized (object) {
                        Channel channel;
                        while (this.leased.size() >= this.poolSize && !this.closed) {
                            this.sync.wait();
                        }
                        if (this.closed) {
                            break;
                        }
                        if (this.available.containsKey(request.channelURI) && SharedChannelPool.isChannelHealthy(channel = this.available.poll(request.channelURI))) {
                            handler.channelAcquired(channel);
                            request.promise.setSuccess((Object)channel);
                            this.leased.put(request.channelURI, channel);
                            continue;
                        }
                        if (this.available.size() > 0 && this.available.size() + this.leased.size() >= this.poolSize) {
                            this.available.poll().close();
                        }
                        int port = request.destinationURI.getPort() < 0 ? ("https".equals(request.destinationURI.getScheme()) ? 443 : 80) : request.destinationURI.getPort();
                        ChannelFuture channelFuture = this.bootstrap.clone().connect(request.destinationURI.getHost(), port);
                        channelFuture.channel().eventLoop().execute(() -> {
                            channelFuture.channel().attr(CHANNEL_URI).set((Object)request.channelURI);
                            if ("https".equalsIgnoreCase(request.destinationURI.getScheme())) {
                                channelFuture.channel().pipeline().addFirst(new ChannelHandler[]{this.sslContext.newHandler(channelFuture.channel().alloc(), request.destinationURI.getHost(), port)});
                            }
                            if (request.proxy != null) {
                                channelFuture.channel().pipeline().addFirst("HttpProxyHandler", (ChannelHandler)new HttpProxyHandler(request.proxy.address()));
                            }
                            this.leased.put(request.channelURI, channelFuture.channel());
                            channelFuture.addListener(future -> {
                                if (future.isSuccess()) {
                                    handler.channelAcquired(future.channel());
                                    request.promise.setSuccess((Object)future.channel());
                                } else {
                                    this.leased.remove(request.channelURI, future.channel());
                                    request.promise.setFailure(future.cause());
                                }
                            });
                        });
                    }
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        });
    }

    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy) {
        return this.acquire(uri, proxy, (Promise<Channel>)this.bootstrap.config().group().next().newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Channel> acquire(URI uri, @Nullable Proxy proxy, Promise<Channel> promise) {
        if (this.closed) {
            throw new RejectedExecutionException("SharedChannelPool is closed");
        }
        ChannelRequest channelRequest = new ChannelRequest();
        channelRequest.promise = promise;
        channelRequest.proxy = proxy;
        int port = uri.getPort() < 0 ? ("https".equals(uri.getScheme()) ? 443 : 80) : uri.getPort();
        try {
            Object address;
            channelRequest.destinationURI = new URI(String.format("%s://%s:%d", uri.getScheme(), uri.getHost(), port));
            if (proxy == null) {
                channelRequest.channelURI = channelRequest.destinationURI;
            } else {
                address = (InetSocketAddress)proxy.address();
                channelRequest.channelURI = new URI(String.format("%s://%s:%d", uri.getScheme(), ((InetSocketAddress)address).getHostString(), ((InetSocketAddress)address).getPort()));
            }
            this.requests.add(channelRequest);
            address = this.requests;
            synchronized (address) {
                this.requests.notify();
            }
        }
        catch (URISyntaxException e) {
            promise.setFailure((Throwable)e);
        }
        return channelRequest.promise;
    }

    public Future<Channel> acquire() {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        throw new UnsupportedOperationException("Please pass host & port to shared channel pool.");
    }

    public Future<Void> closeAndRelease(Channel channel) {
        return channel.close().addListener(future -> this.release(channel));
    }

    public Future<Void> release(Channel channel) {
        return this.release(channel, (Promise<Void>)this.bootstrap.config().group().next().newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        try {
            this.handler.channelReleased(channel);
        }
        catch (Exception e) {
            promise.setFailure((Throwable)e);
            return promise;
        }
        promise.setSuccess(null);
        Object object = this.sync;
        synchronized (object) {
            this.leased.remove((URI)channel.attr(CHANNEL_URI).get(), channel);
            this.available.put((URI)channel.attr(CHANNEL_URI).get(), channel);
            this.sync.notify();
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        this.executor.shutdownNow();
        Queue<ChannelRequest> queue = this.requests;
        synchronized (queue) {
            while (!this.requests.isEmpty()) {
                this.requests.remove().promise.setFailure((Throwable)new CancellationException("Channel pool was closed"));
            }
        }
    }

    private static class ChannelRequest {
        private URI destinationURI;
        private URI channelURI;
        private Proxy proxy;
        private Promise<Channel> promise;

        private ChannelRequest() {
        }
    }
}

