/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.policy;

import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CookiePolicyFactory
implements RequestPolicyFactory {
    private final CookieHandler cookies = new CookieManager();

    @Override
    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new CookiePolicy(next);
    }

    private final class CookiePolicy
    implements RequestPolicy {
        private final RequestPolicy next;

        private CookiePolicy(RequestPolicy next) {
            this.next = next;
        }

        @Override
        public Single<HttpResponse> sendAsync(HttpRequest request) {
            try {
                final URI uri = request.url().toURI();
                HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
                for (HttpHeader header : request.headers()) {
                    cookieHeaders.put(header.name(), Arrays.asList(request.headers().values(header.name())));
                }
                Map<String, List<String>> requestCookies = CookiePolicyFactory.this.cookies.get(uri, cookieHeaders);
                for (Map.Entry<String, List<String>> entry : requestCookies.entrySet()) {
                    request.headers().set(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
                }
                return this.next.sendAsync(request).map((Function)new Function<HttpResponse, HttpResponse>(){

                    public HttpResponse apply(HttpResponse httpResponse) throws Exception {
                        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                        for (HttpHeader header : httpResponse.headers()) {
                            responseHeaders.put(header.name(), Collections.singletonList(header.value()));
                        }
                        CookiePolicyFactory.this.cookies.put(uri, responseHeaders);
                        return httpResponse;
                    }
                });
            }
            catch (IOException | URISyntaxException e) {
                return Single.error((Throwable)e);
            }
        }
    }
}

