/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.rest.v2.serializer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.serializer.JsonFlatten;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FlatteningSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;

    protected FlatteningSerializer(Class<?> vc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(vc, false);
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().getAnnotation(JsonFlatten.class) != null) {
                    return new FlatteningSerializer(beanDesc.getBeanClass(), serializer, mapper);
                }
                return serializer;
            }
        });
        return module;
    }

    private List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Field f : clazz.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private JsonNode serializePartial(Object value) {
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof LocalDate || value instanceof OffsetDateTime || value instanceof String || value instanceof DateTimeRfc1123 || value instanceof Duration) {
            return this.mapper.valueToTree(value);
        }
        int mod = value.getClass().getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            return this.mapper.valueToTree(value);
        }
        if (value instanceof List) {
            ArrayNode node = new ArrayNode(this.mapper.getNodeFactory());
            for (Object val : (List)value) {
                node.add(this.serializePartial(val));
            }
            return node;
        }
        if (value instanceof Map) {
            ObjectNode node = new ObjectNode(this.mapper.getNodeFactory());
            for (Map.Entry entry : ((Map)value).entrySet()) {
                node.set((String)entry.getKey(), this.serializePartial(entry.getValue()));
            }
            return node;
        }
        ObjectNode res = new ObjectNode(this.mapper.getNodeFactory());
        for (Field f : this.getAllDeclaredFields(value.getClass())) {
            f.setAccessible(true);
            String wireName = f.getName();
            ObjectNode pointer = res;
            JsonProperty property = f.getAnnotation(JsonProperty.class);
            if (property != null && !property.value().isEmpty()) {
                wireName = f.getAnnotation(JsonProperty.class).value();
            }
            try {
                Object propValue = f.get(value);
                if (propValue == null) continue;
                if (value.getClass().isAnnotationPresent(JsonFlatten.class) && wireName.matches(".+[^\\\\]\\..+")) {
                    String[] values = wireName.split("((?<!\\\\))\\.");
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].replace("\\.", ".");
                        if (i == values.length - 1) break;
                        String val = values[i];
                        if (!pointer.has(val)) {
                            ObjectNode child = new ObjectNode(this.mapper.getNodeFactory());
                            pointer.set(val, (JsonNode)child);
                            pointer = child;
                            continue;
                        }
                        pointer = (ObjectNode)pointer.get(val);
                    }
                    wireName = values[values.length - 1];
                }
                pointer.set(wireName, this.serializePartial(propValue));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            jgen.writeNull();
            return;
        }
        jgen.writeTree((TreeNode)this.serializePartial(value));
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        ((ResolvableSerializer)this.defaultSerializer).resolve(provider);
    }
}

