/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.core.OrderCES;
import com.miguelangeljulvez.easyredsys.client.util.EasyredsysUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class MessageOrderCESRequest {
    private OrderCES orderCES;
    private static final Logger _log = Logger.getLogger(MessageOrderCESRequest.class.getName());

    private MessageOrderCESRequest() {
    }

    public String getDs_MerchantParameters() {
        String merchanParameters = "";
        try {
            merchanParameters = this.orderCES.apiMacSha256.createMerchantParameters();
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return merchanParameters;
    }

    public String getDs_Signature() {
        String dsSignature = "";
        try {
            dsSignature = this.orderCES.apiMacSha256.createMerchantSignature(EasyredsysUtil.getSecretyKey(this.orderCES));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return dsSignature;
    }

    public String getDs_SignatureVersion() {
        return this.orderCES.getDs_SignatureVersion();
    }

    public OrderCES getOrderCES() {
        return this.orderCES;
    }

    public void setOrderCES(OrderCES orderCES) {
        this.orderCES = orderCES;
    }

    public String getRedsysUrl() {
        return EasyredsysUtil.getRedirectURL(this.orderCES.getAppConfig().isTestMode());
    }

    public static class Builder {
        private OrderCES orderCES;

        public Builder(OrderCES orderCES) {
            this.orderCES = orderCES;
        }

        public MessageOrderCESRequest build() {
            MessageOrderCESRequest messageOrderCESRequest = new MessageOrderCESRequest();
            messageOrderCESRequest.setOrderCES(this.orderCES);
            return messageOrderCESRequest;
        }
    }
}

