/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.core.NotificationNoCES;
import com.miguelangeljulvez.easyredsys.client.core.OrderNoCES;
import com.miguelangeljulvez.easyredsys.client.util.Currency;
import com.miguelangeljulvez.easyredsys.client.util.TransactionType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DATOSENTRADA")
public class OrderNoCESConfirmation
extends OrderNoCES {
    protected OrderNoCESConfirmation() {
        this.apiMacSha256.setParameter("DS_MERCHANT_AUTHORISATIONCODE", "");
    }

    @XmlElement(name="DS_MERCHANT_AUTHORISATIONCODE")
    public String getDs_merchant_authorisationcode() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_AUTHORISATIONCODE");
    }

    public void setDs_merchant_authorisationcode(String ds_merchant_authorisationcode) {
        this.apiMacSha256.setParameter("DS_MERCHANT_AUTHORISATIONCODE", ds_merchant_authorisationcode);
    }

    public static class Builder {
        private long merchantCode;
        private long terminal;
        private String transactionType;
        private long currency;
        private String order;
        private long amount;
        private String ds_merchant_authorisationcode = "";
        private String cardNumber = "";
        private String cvv2 = "";
        private String expiryDate = "";
        private AppConfig appConfig;

        public Builder(Class<? extends AppConfig> userActionClass) {
            try {
                this.appConfig = userActionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }

        public Builder(AppConfig userActionClass) {
            this.appConfig = userActionClass;
        }

        public Builder(NotificationNoCES notificationNoCES) {
            this.merchantCode = Long.parseLong(notificationNoCES.getDs_MerchantCode());
            this.terminal = Long.parseLong(notificationNoCES.getDs_Terminal());
            this.currency = Long.parseLong(notificationNoCES.getDs_Currency());
            this.ds_merchant_authorisationcode = notificationNoCES.getDs_AuthorisationCode();
        }

        public Builder merchantCode(String merchantCode) {
            this.merchantCode = Long.parseLong(merchantCode);
            return this;
        }

        public Builder terminal(String terminal) {
            this.terminal = Long.parseLong(terminal);
            return this;
        }

        public Builder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType.getCode();
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency.getISOCodeNumeric();
            return this;
        }

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder cardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public Builder cvv2(String cvv2) {
            this.cvv2 = cvv2;
            return this;
        }

        public Builder expiryDate(String expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public OrderNoCESConfirmation build() {
            OrderNoCESConfirmation orderNoCESConfirmation = new OrderNoCESConfirmation();
            orderNoCESConfirmation.setDs_merchant_merchantcode(this.merchantCode);
            orderNoCESConfirmation.setDs_merchant_terminal(this.terminal);
            orderNoCESConfirmation.setDs_merchant_transactiontype(this.transactionType);
            orderNoCESConfirmation.setDs_merchant_currency(this.currency);
            orderNoCESConfirmation.setDs_merchant_order(this.order);
            orderNoCESConfirmation.setDs_merchant_amount(this.amount);
            orderNoCESConfirmation.setDs_merchant_authorisationcode(this.ds_merchant_authorisationcode);
            orderNoCESConfirmation.setDs_merchant_pan(this.cardNumber);
            orderNoCESConfirmation.setDs_merchant_cvv2(this.cvv2);
            orderNoCESConfirmation.setDs_merchant_expirydate(this.expiryDate);
            orderNoCESConfirmation.setAppConfig(this.appConfig);
            return orderNoCESConfirmation;
        }
    }
}

