/*
 * Decompiled with CFR 0.152.
 */
package sis.redsys.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.Arrays;

public class ApiWsMacSha256 {
    private final short OCHO = (short)8;
    private final byte[] IV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public byte[] encrypt_3DES(String claveHex, String datos) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        byte[] ciphertext = null;
        DESedeKeySpec desKeySpec = new DESedeKeySpec(this.toByteArray(claveHex));
        SecretKeySpec desKey = new SecretKeySpec(desKeySpec.getKey(), "DESede");
        Cipher desCipher = Cipher.getInstance("DESede/CBC/NoPadding");
        desCipher.init(1, (Key)desKey, new IvParameterSpec(this.IV));
        int numeroCerosNecesarios = 8 - datos.length() % 8;
        if (numeroCerosNecesarios == 8) {
            numeroCerosNecesarios = 0;
        }
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        array.write(datos.getBytes("UTF-8"), 0, datos.length());
        for (int i = 0; i < numeroCerosNecesarios; ++i) {
            array.write(0);
        }
        byte[] cleartext = array.toByteArray();
        ciphertext = desCipher.doFinal(cleartext);
        return ciphertext;
    }

    public String encodeB64String(byte[] data) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])data), "UTF-8");
    }

    public byte[] encodeB64(byte[] data) {
        return Base64.encodeBase64((byte[])data);
    }

    public byte[] encodeB64UrlSafe(byte[] data) {
        byte[] encode = Base64.encodeBase64((byte[])data);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 43) {
                encode[i] = 45;
                continue;
            }
            if (encode[i] != 47) continue;
            encode[i] = 95;
        }
        return encode;
    }

    public String decodeB64String(byte[] data) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((byte[])data), "UTF-8");
    }

    public byte[] decodeB64(byte[] data) {
        return Base64.decodeBase64((byte[])data);
    }

    public byte[] decodeB64UrlSafe(byte[] data) {
        byte[] encode = Arrays.copyOf((byte[])data, (int)data.length);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 45) {
                encode[i] = 43;
                continue;
            }
            if (encode[i] != 95) continue;
            encode[i] = 47;
        }
        return Base64.decodeBase64((byte[])encode);
    }

    public String toHexadecimal(byte[] datos, int numBytes) {
        String resultado = "";
        ByteArrayInputStream input = new ByteArrayInputStream(datos, 0, numBytes);
        int leido = input.read();
        while (leido != -1) {
            String cadAux = Integer.toHexString(leido);
            if (cadAux.length() < 2) {
                resultado = resultado + "0";
            }
            resultado = resultado + cadAux;
            leido = input.read();
        }
        return resultado;
    }

    public byte[] toByteArray(String cadena) {
        if (cadena.length() % 2 != 0) {
            cadena = "0" + cadena;
        }
        int longitud = cadena.length() / 2;
        int posicion = 0;
        String cadenaAux = null;
        ByteArrayOutputStream salida = new ByteArrayOutputStream();
        for (int i = 0; i < longitud; ++i) {
            cadenaAux = cadena.substring(posicion, posicion + 2);
            posicion += 2;
            salida.write((char)Integer.parseInt(cadenaAux, 16));
        }
        return salida.toByteArray();
    }

    public byte[] mac256(String dsMerchantParameters, byte[] secretKo) throws IllegalStateException, UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException {
        Mac sha256HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(secretKo, "HmacSHA256");
        sha256HMAC.init(secretKey);
        byte[] hash = sha256HMAC.doFinal(dsMerchantParameters.getBytes("UTF-8"));
        return hash;
    }

    public String getOrder(String datos) {
        int posPedidoIni = datos.indexOf("<DS_MERCHANT_ORDER>");
        int tamPedidoIni = "<DS_MERCHANT_ORDER>".length();
        int posPedidoFin = datos.indexOf("</DS_MERCHANT_ORDER>");
        return datos.substring(posPedidoIni + tamPedidoIni, posPedidoFin);
    }

    public String createMerchantSignatureHostToHost(String claveComercio, String datosEntrada) throws UnsupportedEncodingException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        byte[] clave = this.decodeB64(claveComercio.getBytes("UTF-8"));
        String secretKc = this.toHexadecimal(clave, clave.length);
        byte[] secretKo = this.encrypt_3DES(secretKc, this.getOrder(datosEntrada));
        byte[] hash = this.mac256(datosEntrada, secretKo);
        String res = this.encodeB64String(hash);
        return res;
    }

    public String createSignatureResponseHostToHost(String claveComercio, String datosEntrada, String numPedido) throws UnsupportedEncodingException, InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        byte[] clave = this.decodeB64(claveComercio.getBytes("UTF-8"));
        String secretKc = this.toHexadecimal(clave, clave.length);
        byte[] secretKo = this.encrypt_3DES(secretKc, numPedido);
        byte[] hash = this.mac256(datosEntrada, secretKo);
        String res = this.encodeB64String(hash);
        return res;
    }
}

