/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;

public class BPFLoader
extends Program {
    public static final PublicKey PROGRAM_ID = new PublicKey("BPFLoaderUpgradeab1e11111111111111111111111");
    public static final PublicKey SYSVAR_RENT_PUBKEY = new PublicKey("SysvarRent111111111111111111111111111111111");
    public static final PublicKey SYSVAR_CLOCK_PUBKEY = new PublicKey("SysvarC1ock11111111111111111111111111111111");
    public static final PublicKey SYSTEM_PROGRAM_ID = new PublicKey("11111111111111111111111111111111");

    public static TransactionInstruction initializeBuffer(PublicKey newAccount, PublicKey bufferAuthority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(newAccount, false, true));
        if (bufferAuthority != null) {
            keys.add(new AccountMeta(bufferAuthority, false, false));
        }
        ByteBuffer data = ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)0);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction write(PublicKey writeableBuffer, PublicKey bufferAuthority, byte[] data) {
        return BPFLoader.write(writeableBuffer, bufferAuthority, 0L, data);
    }

    public static TransactionInstruction write(PublicKey writeableBuffer, PublicKey bufferAuthority, long offset, byte[] data) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(writeableBuffer, false, true));
        keys.add(new AccountMeta(bufferAuthority, true, false));
        ByteBuffer instructionData = ByteBuffer.allocate(5 + data.length).order(ByteOrder.LITTLE_ENDIAN);
        instructionData.put((byte)1);
        instructionData.putInt((int)offset);
        instructionData.put(data);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, instructionData.array());
    }

    public static TransactionInstruction deployWithMaxDataLen(PublicKey payer, PublicKey programData, PublicKey program, PublicKey buffer, PublicKey programAuthority, long maxDataLen) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(payer, true, true));
        keys.add(new AccountMeta(programData, false, true));
        keys.add(new AccountMeta(program, false, true));
        keys.add(new AccountMeta(buffer, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        keys.add(new AccountMeta(SYSVAR_CLOCK_PUBKEY, false, false));
        keys.add(new AccountMeta(SYSTEM_PROGRAM_ID, false, false));
        keys.add(new AccountMeta(programAuthority, true, false));
        ByteBuffer data = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)2);
        data.putLong(maxDataLen);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction upgrade(PublicKey programData, PublicKey program, PublicKey buffer, PublicKey spillAccount, PublicKey programAuthority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(programData, false, true));
        keys.add(new AccountMeta(program, false, true));
        keys.add(new AccountMeta(buffer, false, true));
        keys.add(new AccountMeta(spillAccount, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        keys.add(new AccountMeta(SYSVAR_CLOCK_PUBKEY, false, false));
        keys.add(new AccountMeta(programAuthority, true, false));
        ByteBuffer data = ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)3);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction setAuthority(PublicKey account, PublicKey currentAuthority, PublicKey newAuthority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(currentAuthority, true, false));
        if (newAuthority != null) {
            keys.add(new AccountMeta(newAuthority, false, false));
        }
        ByteBuffer data = ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)4);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction close(PublicKey account, PublicKey recipient, PublicKey authority, PublicKey programAccount) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(recipient, false, true));
        if (authority != null) {
            keys.add(new AccountMeta(authority, true, false));
        }
        if (programAccount != null) {
            keys.add(new AccountMeta(programAccount, false, true));
        }
        ByteBuffer data = ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)5);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction extendProgram(PublicKey programData, PublicKey program, PublicKey payer, int additionalBytes) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(programData, false, true));
        keys.add(new AccountMeta(program, false, true));
        keys.add(new AccountMeta(SYSTEM_PROGRAM_ID, false, false));
        if (payer != null) {
            keys.add(new AccountMeta(payer, true, true));
        }
        ByteBuffer data = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)6);
        data.putInt(additionalBytes);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }

    public static TransactionInstruction setAuthorityChecked(PublicKey account, PublicKey currentAuthority, PublicKey newAuthority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(currentAuthority, true, false));
        keys.add(new AccountMeta(newAuthority, true, false));
        ByteBuffer data = ByteBuffer.allocate(1).order(ByteOrder.LITTLE_ENDIAN);
        data.put((byte)7);
        return BPFLoader.createTransactionInstruction(PROGRAM_ID, keys, data.array());
    }
}

