/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc;

import java.io.IOException;
import java.util.logging.Logger;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class LoggingInterceptor
implements Interceptor {
    private static final Logger LOGGER = Logger.getLogger(LoggingInterceptor.class.getName());

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        LOGGER.info(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        System.out.println("Buffer = " + LoggingInterceptor.bodyToString(request));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        LOGGER.info(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }

    private static String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "did not work";
        }
    }
}

