/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.connection.RedisObjectStore;
import org.mule.extension.redis.internal.error.exceptions.InvalidDataException;
import org.mule.extension.redis.internal.error.exceptions.RedisConnectionException;
import org.mule.extension.redis.internal.error.exceptions.UnableToRetrieveResponseException;
import org.mule.extension.redis.internal.error.exceptions.UnableToSendRequestException;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public abstract class ExecutableRedisConnection<C>
implements ObjectStoreManager,
RedisConnection {
    private final Map<String, RedisObjectStore> objectStores = new HashMap<String, RedisObjectStore>();
    private final Integer entryTTL;
    private final Scheduler scheduler;
    private final RedisAPIService service;
    private final ObjectSerializer serializer;

    public ExecutableRedisConnection(Integer entryTTL, ObjectSerializer serializer, Scheduler scheduler, Function<ExecutableRedisConnection, RedisAPIService> serviceStrategy) {
        this.serializer = serializer;
        this.entryTTL = entryTTL;
        this.scheduler = scheduler;
        this.service = serviceStrategy.apply(this);
    }

    public <T> T execute(Function<C, T> function) {
        try {
            return this.doExecute(function);
        }
        catch (JedisClusterOperationException | JedisDataException e) {
            throw new InvalidDataException("Invalid data sending to redis: " + e.getMessage(), (Exception)e);
        }
        catch (JedisConnectionException e) {
            throw new RedisConnectionException("Something went wrong while connecting to redis: " + e.getMessage(), e);
        }
        catch (JedisException e) {
            throw new UnableToSendRequestException("Something went wrong while sending data to redis: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidDataException("Invalid data sent to Redis: " + e.getMessage(), e);
        }
    }

    protected abstract <T> T doExecute(Function<C, T> var1);

    public <T> T executeExpectingResponse(Function<C, T> function) {
        return Optional.ofNullable(this.execute(function)).orElseThrow(UnableToRetrieveResponseException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> getObjectStore(String name) {
        ExecutableRedisConnection executableRedisConnection = this;
        synchronized (executableRedisConnection) {
            return (ObjectStore)Optional.ofNullable(this.objectStores.get(name)).orElseThrow(() -> new IllegalArgumentException("An Object Store was not defined for name " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> createObjectStore(String name, ObjectStoreSettings settings) {
        ExecutableRedisConnection executableRedisConnection = this;
        synchronized (executableRedisConnection) {
            if (this.objectStores.containsKey(name)) {
                throw new IllegalArgumentException("An Object Store was already defined for name " + name);
            }
            RedisObjectStore store = new RedisObjectStore(this, this.serializer, this.entryTTL, settings, name, this.scheduler);
            try {
                store.open();
            }
            catch (ObjectStoreException e) {
                throw new UnableToSendRequestException(e.getMessage(), (Exception)((Object)e));
            }
            this.objectStores.put(name, store);
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStore<Serializable> getOrCreateObjectStore(String name, ObjectStoreSettings settings) {
        ExecutableRedisConnection executableRedisConnection = this;
        synchronized (executableRedisConnection) {
            RedisObjectStore store;
            if (this.objectStores.containsKey(name)) {
                store = this.objectStores.get(name);
            } else {
                try {
                    store = new RedisObjectStore(this, this.serializer, this.entryTTL, settings, name, this.scheduler);
                    store.open();
                }
                catch (ObjectStoreException e) {
                    throw new UnableToSendRequestException(e.getMessage(), (Exception)((Object)e));
                }
                this.objectStores.put(name, store);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeStore(String name) throws ObjectStoreException {
        ExecutableRedisConnection executableRedisConnection = this;
        synchronized (executableRedisConnection) {
            if (this.objectStores.containsKey(name)) {
                this.objectStores.get(name).clear();
                this.objectStores.remove(name);
            }
        }
    }

    public void disconnect() {
        this.objectStores.values().forEach(RedisObjectStore::close);
    }

    @Override
    public Integer getEntryTTL() {
        return this.entryTTL;
    }
}

