/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.util.function.Function;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.service.ClusteredApiService;
import org.mule.extension.redis.internal.service.cluster.ClusteredClientAdapter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import redis.clients.jedis.JedisCluster;

public class RedisClusteredConnection
extends ExecutableRedisConnection<JedisCluster> {
    private final JedisCluster jedisCluster;

    public RedisClusteredConnection(JedisCluster jedisCluster, Integer entryTTL, ObjectSerializer serializer, Scheduler scheduler) {
        super(entryTTL, serializer, scheduler, ClusteredApiService::new);
        this.jedisCluster = jedisCluster;
    }

    @Override
    public <T> T doExecute(Function<JedisCluster, T> function) {
        return function.apply(this.jedisCluster);
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.jedisCluster.close();
    }

    public void validate() {
        this.jedisCluster.echo("ping");
    }

    public ClusteredClientAdapter getClientAdapter() {
        return new ClusteredClientAdapter(this.jedisCluster);
    }
}

