/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import java.util.HashSet;
import java.util.UUID;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.connection.RedisClusteredConnection;
import org.mule.extension.redis.internal.connection.param.ClusteredConnectionParams;
import org.mule.extension.redis.internal.connection.provider.RedisSSLConnectionProvider;
import org.mule.extension.redis.internal.stereotype.ObjectStoreConnectionStereotype;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Alias(value="clustered")
@DisplayName(value="Clustered")
@Stereotype(value=ObjectStoreConnectionStereotype.class)
public class ClusteredConnectionProvider
extends RedisSSLConnectionProvider<ExecutableRedisConnection>
implements CachedConnectionProvider<ExecutableRedisConnection> {
    private static final Logger logger = LoggerFactory.getLogger(ClusteredConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private ClusteredConnectionParams clusterConnectionParams;

    @Override
    public ExecutableRedisConnection connect(Scheduler scheduler, ObjectSerializer serializer, JedisPoolConfig jedisPoolConfig, boolean isSSL, SSLParameters sslParameters, SSLSocketFactory socketFactory) {
        String clusterHosts = this.clusterConnectionParams.getClusterHosts();
        HashSet<HostAndPort> jedisClusterNodes = new HashSet<HostAndPort>();
        for (String hostAndPort : clusterHosts.split(",")) {
            String[] fields = hostAndPort.split(":");
            jedisClusterNodes.add(new HostAndPort(fields[0], Integer.parseInt(fields[1])));
        }
        int connectionTimeout = this.clusterConnectionParams.getConnectionTimeout();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Redis connector ready, clusterHosts: %s, timeout: %d", clusterHosts, connectionTimeout));
        }
        return new RedisClusteredConnection(new JedisCluster(jedisClusterNodes, connectionTimeout, (int)this.clusterConnectionParams.getConnectionTimeUnit().toMillis(this.clusterConnectionParams.getConnectionTimeout()), 5, null, this.clusterConnectionParams.getPassword(), String.format("%s-%s", this.getConfigName(), UUID.randomUUID()), (GenericObjectPoolConfig)jedisPoolConfig, isSSL, socketFactory, sslParameters, null, null), this.clusterConnectionParams.getEntryTTL(), serializer, scheduler);
    }
}

