/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import javax.inject.Inject;
import javax.inject.Named;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.connection.param.PoolConfigParams;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import redis.clients.jedis.JedisPoolConfig;

public abstract class RedisConnectionProvider<C extends ExecutableRedisConnection>
extends ConnectorConnectionProvider<C>
implements ConnectionProvider<C>,
Initialisable {
    @RefName
    private String configName;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    private ObjectSerializer serializer;
    @Inject
    @Named(value="_muleSchedulerBaseConfig")
    private SchedulerConfig schedulerConfig;
    @ParameterGroup(name="Pooling")
    @Placement(order=2)
    private PoolConfigParams poolConfigParams;

    public C connect() throws ConnectionException {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.poolConfigParams.getMaxTotal());
        jedisPoolConfig.setMaxIdle(this.poolConfigParams.getMaxIdle());
        jedisPoolConfig.setMinIdle(this.poolConfigParams.getMinIdle());
        jedisPoolConfig.setLifo(this.poolConfigParams.getLifo());
        jedisPoolConfig.setFairness(this.poolConfigParams.getFairness());
        jedisPoolConfig.setMaxWaitMillis(this.poolConfigParams.getMaxWaitMillis());
        jedisPoolConfig.setMinEvictableIdleTimeMillis(this.poolConfigParams.getMinEvictableIdleTimeMillis());
        jedisPoolConfig.setSoftMinEvictableIdleTimeMillis(this.poolConfigParams.getSoftMinEvictableIdleTimeMillis());
        jedisPoolConfig.setNumTestsPerEvictionRun(this.poolConfigParams.getNumTestsPerEvictionRun());
        jedisPoolConfig.setTestOnCreate(this.poolConfigParams.getTestOnCreate());
        jedisPoolConfig.setTestOnBorrow(this.poolConfigParams.getTestOnBorrow());
        jedisPoolConfig.setTestOnReturn(this.poolConfigParams.getTestOnReturn());
        jedisPoolConfig.setTestWhileIdle(this.poolConfigParams.getTestWhileIdle());
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.poolConfigParams.getTimeBetweenEvictionRunsMillis());
        jedisPoolConfig.setBlockWhenExhausted(this.poolConfigParams.getBlockWhenExhausted());
        jedisPoolConfig.setJmxEnabled(this.poolConfigParams.getJmxEnabled());
        jedisPoolConfig.setJmxNameBase(this.poolConfigParams.getJmxNameBase());
        jedisPoolConfig.setJmxNamePrefix(this.poolConfigParams.getJmxNamePrefix());
        return this.connect(this.schedulerService.customScheduler(this.schedulerConfig.withName(this.configName + "-Monitor").withMaxConcurrentTasks(1)), this.serializer, jedisPoolConfig);
    }

    protected String getConfigName() {
        return this.configName;
    }

    protected abstract C connect(Scheduler var1, ObjectSerializer var2, JedisPoolConfig var3);
}

