/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.error.exceptions.InvalidDataException;
import org.mule.extension.redis.internal.error.exceptions.RedisConnectionException;
import org.mule.extension.redis.internal.error.exceptions.UnableToRetrieveResponseException;
import org.mule.extension.redis.internal.error.exceptions.UnableToSendRequestException;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.utils.RedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.SafeEncoder;

public class PooledApiService
implements RedisAPIService {
    private ExecutableRedisConnection<Jedis> connection;

    public PooledApiService(ExecutableRedisConnection<Jedis> connection) {
        this.connection = connection;
    }

    @Override
    public Long setnx(String key, byte[] value) {
        return this.connection.executeExpectingResponse(jedis -> jedis.setnx(SafeEncoder.encode((String)key), value));
    }

    @Override
    public String set(String key, String value, Integer entryTTL, boolean ifNotExists) {
        String usedValue = Optional.ofNullable(value).orElse("");
        String result = this.connection.executeExpectingResponse(ifNotExists ? jedisCommands -> Optional.ofNullable(jedisCommands.setnx(key, usedValue)).map(Long::intValue).orElse(0) == 1 ? "OK" : null : jedisCommands -> jedisCommands.set(key, usedValue));
        Optional.ofNullable(entryTTL).ifPresent(ttl -> this.expire(key, (int)ttl));
        return result;
    }

    @Override
    public byte[] set(String key, byte[] value, Integer entryTTL, boolean ifNotExists) throws InvalidDataException, RedisConnectionException, UnableToSendRequestException, UnableToRetrieveResponseException {
        return this.connection.execute(jedis -> {
            String result = null;
            if (ifNotExists) {
                if (this.setnx(key, value) == 0L) {
                    result = null;
                }
            } else {
                result = jedis.set(SafeEncoder.encode((String)key), value);
            }
            if (entryTTL != null) {
                this.expire(key, entryTTL);
            }
            if (result != null) {
                return result.getBytes();
            }
            return null;
        });
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.connection.executeExpectingResponse(jedis -> jedis.expire(SafeEncoder.encode((String)key), seconds));
    }

    @Override
    public byte[] get(String key) {
        return this.connection.execute(jedis -> jedis.get(SafeEncoder.encode((String)key)));
    }

    @Override
    public boolean exists(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.exists(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long incr(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.incr(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long incrBy(String key, long integer) {
        return this.connection.executeExpectingResponse(jedis -> jedis.incrBy(SafeEncoder.encode((String)key), integer));
    }

    @Override
    public Long decr(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.decr(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long decrBy(String key, long integer) {
        return this.connection.executeExpectingResponse(jedis -> jedis.decrBy(SafeEncoder.encode((String)key), integer));
    }

    @Override
    public Long hsetnx(String key, byte[] field, byte[] value) {
        return this.connection.executeExpectingResponse(jedis -> jedis.hsetnx(SafeEncoder.encode((String)key), field, value));
    }

    @Override
    public Long hset(String key, String value, String field, boolean ifNotExists) {
        return this.connection.executeExpectingResponse(jedis -> {
            Long response = null;
            byte[] fieldAsBytes = SafeEncoder.encode((String)field);
            byte[] valueAsBytes = RedisUtils.toUTF8Bytes(value);
            response = ifNotExists ? jedis.hsetnx(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes) : jedis.hset(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes);
            return response;
        });
    }

    @Override
    public byte[] hget(String key, String field) {
        return this.connection.execute(jedis -> jedis.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field)));
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.hgetAll(key));
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.connection.executeExpectingResponse(jedis -> jedis.hincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value));
    }

    @Override
    public Set<byte[]> hkeys(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.hkeys(SafeEncoder.encode((String)key)));
    }

    @Override
    public Set<byte[]> keys(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.keys(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long del(String ... keys) {
        return this.connection.executeExpectingResponse(jedis -> jedis.del(keys));
    }

    @Override
    public byte[] rpop(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.rpop(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long lpushx(String key, String string) {
        return this.connection.executeExpectingResponse(jedis -> jedis.lpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long lpush(String key, String string) {
        return this.connection.executeExpectingResponse(jedis -> jedis.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long sadd(String key, byte[] string) {
        return this.connection.executeExpectingResponse(jedis -> jedis.sadd(SafeEncoder.encode((String)key), (byte[][])new byte[][]{string}));
    }

    @Override
    public byte[] spop(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.spop(SafeEncoder.encode((String)key)));
    }

    @Override
    public byte[] srandmember(String key) {
        return this.connection.execute(jedis -> jedis.srandmember(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long zadd(String key, double score, byte[] member) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zadd(SafeEncoder.encode((String)key), score, member));
    }

    @Override
    public byte[] lpop(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.lpop(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long rpushx(String key, String string) {
        return this.connection.executeExpectingResponse(jedis -> jedis.rpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long rpush(String key, String string) {
        return this.connection.executeExpectingResponse(jedis -> jedis.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Set<byte[]> zrange(String key, long start, long end) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zrange(SafeEncoder.encode((String)key), start, end));
    }

    @Override
    public Set<byte[]> zrangeByScore(String key, double min, double max) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zrangeByScore(SafeEncoder.encode((String)key), min, max));
    }

    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zrevrange(SafeEncoder.encode((String)key), start, end));
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, double max, double min) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zrevrangeByScore(SafeEncoder.encode((String)key), max, min));
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.connection.executeExpectingResponse(jedis -> jedis.zincrby(SafeEncoder.encode((String)key), score, RedisUtils.toUTF8Bytes(member)));
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        return this.connection.executeExpectingResponse(jedis -> jedis.expireAt(SafeEncoder.encode((String)key), unixTime));
    }

    @Override
    public Long persist(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.persist(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long ttl(String key) {
        return this.connection.executeExpectingResponse(jedis -> jedis.ttl(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long publish(String channel, String message) {
        return this.connection.executeExpectingResponse(jedis -> jedis.publish(channel, message));
    }

    @Override
    public boolean hexists(String key, byte[] field) {
        return this.connection.executeExpectingResponse(jedis -> jedis.hexists(SafeEncoder.encode((String)key), field));
    }

    @Override
    public String ltrim(String key, long start, long stop) throws InvalidDataException, RedisConnectionException, UnableToSendRequestException, UnableToRetrieveResponseException {
        return this.connection.executeExpectingResponse(jedis -> jedis.ltrim(SafeEncoder.encode((String)key), start, stop));
    }

    @Override
    public List<String> lrange(String key, long start, long stop) throws InvalidDataException, RedisConnectionException, UnableToSendRequestException, UnableToRetrieveResponseException {
        return this.connection.executeExpectingResponse(jedis -> jedis.lrange(SafeEncoder.encode((String)key), start, stop)).stream().map(i -> SafeEncoder.encode((byte[])i)).collect(Collectors.toList());
    }
}

