/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.runtime.DiscoverProduct;
import org.mule.munit.plugin.maven.runtime.DiscoverRuntimes;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.munit.plugin.maven.runtime.ProductDiscoveryMode;
import org.mule.munit.plugin.maven.runtime.RuntimeConfiguration;

public class ProductConfiguration {
    public static final String ADDITIONAL_PRODUCTS_PROPERTY = "additionalProducts";
    public static final String ADDITIONAL_PRODUCTS_SEPARATOR = ",";
    private List<DiscoverProduct> discoverProducts;
    private List<String> additionalProducts = Collections.emptyList();

    public ProductConfiguration() {
    }

    private ProductConfiguration(List<DiscoverProduct> discoverProducts, List<String> additionalProducts) {
        this.discoverProducts = discoverProducts;
        this.additionalProducts = additionalProducts;
    }

    public List<DiscoverProduct> getDiscoverProducts() {
        return this.discoverProducts;
    }

    public List<String> getAdditionalProducts() {
        return this.additionalProducts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<DiscoverProduct> discoverProducts = new ArrayList<DiscoverProduct>();
        private List<String> additionalProducts = Collections.emptyList();

        public Builder from(ProductConfiguration productConfiguration) {
            if (productConfiguration == null) {
                return this;
            }
            this.discoverProducts = productConfiguration.getDiscoverProducts().stream().map(discoverProduct -> DiscoverProduct.builder().from((DiscoverProduct)discoverProduct).build()).collect(Collectors.toList());
            this.additionalProducts = productConfiguration.getAdditionalProducts();
            return this;
        }

        public Builder withRuntimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            if (runtimeConfiguration == null) {
                return this;
            }
            runtimeConfiguration.getDiscoverRuntimes().ifPresent(discoverRuntimes -> {
                if (!discoverRuntimes.getProduct().isPresent()) {
                    this.withRuntimeConfiguration((DiscoverRuntimes)discoverRuntimes, null);
                    return;
                }
                discoverRuntimes.getProduct().ifPresent(product -> {
                    if (product == ProductDiscoveryMode.CE) {
                        this.withRuntimeConfiguration((DiscoverRuntimes)discoverRuntimes, Product.MULE_CE);
                    } else if (product == ProductDiscoveryMode.EE) {
                        this.withRuntimeConfiguration((DiscoverRuntimes)discoverRuntimes, Product.MULE_EE);
                    } else if (product == ProductDiscoveryMode.ALL) {
                        this.withRuntimeConfiguration((DiscoverRuntimes)discoverRuntimes, Product.MULE_CE);
                        this.withRuntimeConfiguration((DiscoverRuntimes)discoverRuntimes, Product.MULE_EE);
                    }
                });
            });
            this.additionalProducts = runtimeConfiguration.getAdditionalRuntimes();
            return this;
        }

        private void withRuntimeConfiguration(DiscoverRuntimes discoverRuntimes, Product product) {
            DiscoverProduct.Builder builder = DiscoverProduct.builder();
            discoverRuntimes.getMinMuleVersion().ifPresent(builder::withMinVersion);
            this.discoverProducts.add(builder.withProductId(product).includingSnapshots(discoverRuntimes.isIncludeSnapshots()).skip(discoverRuntimes.isSkipped()).useLatestPatches(discoverRuntimes.isUseLatestPatches()).withRuntimeRepositories(discoverRuntimes.getRuntimeRepositories()).build());
        }

        public Builder withAdditionalProducts(List<String> additionalProducts) {
            this.additionalProducts = additionalProducts;
            return this;
        }

        public Builder withOverrides(Properties userProperties) {
            if (userProperties == null) {
                return this;
            }
            this.discoverProducts = this.discoverProducts.stream().map(discoverProduct -> DiscoverProduct.builder().from((DiscoverProduct)discoverProduct).withOverrides(userProperties).build()).collect(Collectors.toList());
            if (userProperties.containsKey(ProductConfiguration.ADDITIONAL_PRODUCTS_PROPERTY)) {
                this.additionalProducts = Arrays.asList(StringUtils.split((String)userProperties.getProperty(ProductConfiguration.ADDITIONAL_PRODUCTS_PROPERTY), (String)ProductConfiguration.ADDITIONAL_PRODUCTS_SEPARATOR));
            }
            return this;
        }

        public ProductConfiguration build() {
            return new ProductConfiguration(this.discoverProducts, this.additionalProducts);
        }
    }
}

