/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.HeaderSection;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.header.HeaderSource;
import com.mycila.maven.plugin.license.util.FileUtils;
import com.mycila.maven.plugin.license.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Header {
    private final HeaderSource location;
    private final String headerContent;
    private final String headerContentOneLine;
    private String[] lines;
    private final HeaderSection[] sections;
    private final int maxLength;

    public Header(HeaderSource location, HeaderSection[] sections) {
        this.location = location;
        this.sections = sections;
        try {
            this.headerContent = location.getContent();
            this.lines = this.headerContent.replace("\r", "").split("\n");
            this.headerContentOneLine = FileUtils.remove(this.headerContent, " ", "\t", "\r", "\n");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + location + ". Cause: " + e.getMessage(), e);
        }
        int maxLength = 0;
        for (String line : this.lines) {
            if (line.length() <= maxLength) continue;
            maxLength = line.length();
        }
        this.maxLength = maxLength;
    }

    public String asString() {
        return this.headerContent;
    }

    public String asOneLineString() {
        return this.headerContentOneLine;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public int getMaxLineLength() {
        return this.maxLength;
    }

    public HeaderSource getLocation() {
        return this.location;
    }

    public String eol(boolean unix) {
        return unix ? "\n" : "\r\n";
    }

    public String buildForDefinition(HeaderDefinition type, boolean unix) {
        StringBuilder newHeader = new StringBuilder();
        String unixEndOfLine = this.eol(unix);
        if (this.notEmpty(type.getFirstLine())) {
            String firstLine = type.getFirstLine().replace("EOL", unixEndOfLine);
            newHeader.append(firstLine);
            if (!firstLine.equals(unixEndOfLine)) {
                newHeader.append(unixEndOfLine);
            }
        }
        for (String line : this.getLines()) {
            String before = type.getBeforeEachLine().replace("EOL", unixEndOfLine);
            String after = type.getAfterEachLine().replace("EOL", unixEndOfLine);
            String str = type.isPadLines() ? before + StringUtils.padRight(line, this.maxLength) + after : before + (String)line + after;
            newHeader.append(StringUtils.rtrim(str));
            newHeader.append(unixEndOfLine);
        }
        if (this.notEmpty(type.getEndLine())) {
            String endLine = type.getEndLine().replace("EOL", unixEndOfLine);
            newHeader.append(endLine);
            if (!endLine.equals(unixEndOfLine)) {
                newHeader.append(unixEndOfLine);
            }
        }
        return newHeader.toString();
    }

    public String toString() {
        return this.asString();
    }

    public String[] getLines() {
        return this.lines;
    }

    public boolean isMatchForText(String potentialFileHeader, HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        return this.isMatchForText(expected, potentialFileHeader, headerDefinition, unix);
    }

    public boolean isMatchForText(String expected, String potentialFileHeader, HeaderDefinition headerDefinition, boolean unix) {
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return potentialFileHeader.contains(expected);
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        return this.recursivelyFindMatch(potentialFileHeader, headerDefinition, textBetweenSections, sectionsInOrder, 0, 0);
    }

    public boolean isMatchForText(Document d, HeaderDefinition headerDefinition, boolean unix, Charset encoding) throws IOException {
        String fileHeader = FileUtils.readFirstLines(d.getFile(), this.getLineCount() + 10, encoding).replaceAll(" *\r?\n", "\n");
        String expected = this.buildForDefinition(headerDefinition, unix);
        expected = d.mergeProperties(expected);
        return this.isMatchForText(expected, fileHeader, headerDefinition, unix);
    }

    public String applyDefinitionAndSections(HeaderDefinition headerDefinition, boolean unix) {
        String expected = this.buildForDefinition(headerDefinition, unix);
        SortedMap<Integer, HeaderSection> sectionsByIndex = this.computeSectionsByIndex(expected);
        if (sectionsByIndex.isEmpty()) {
            return expected;
        }
        List<String> textBetweenSections = this.buildExpectedTextBetweenSections(expected, sectionsByIndex);
        ArrayList<HeaderSection> sectionsInOrder = new ArrayList<HeaderSection>(sectionsByIndex.values());
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < textBetweenSections.size(); ++i) {
            HeaderSection section;
            String sectionValue;
            String textBetween = textBetweenSections.get(i);
            b.append(textBetween);
            if (i >= sectionsInOrder.size() || !this.notEmpty(sectionValue = (section = (HeaderSection)sectionsInOrder.get(i)).getDefaultValue())) continue;
            String[] tokens = sectionValue.split(this.eol(unix));
            for (int j = 0; j < tokens.length; ++j) {
                if (j > 0) {
                    b.append(this.eol(unix));
                    if (this.notEmpty(headerDefinition.getBeforeEachLine())) {
                        b.append(headerDefinition.getBeforeEachLine());
                    }
                    b.append(tokens[j]);
                    if (!this.notEmpty(headerDefinition.getAfterEachLine())) continue;
                    b.append(headerDefinition.getAfterEachLine());
                    continue;
                }
                b.append(tokens[j]);
            }
        }
        return b.toString();
    }

    private boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private SortedMap<Integer, HeaderSection> computeSectionsByIndex(String expectedHeaderText) {
        TreeMap<Integer, HeaderSection> sectionsByIndex = new TreeMap<Integer, HeaderSection>();
        if (this.sections == null) {
            return sectionsByIndex;
        }
        for (HeaderSection section : this.sections) {
            String key = section.getKey();
            int index = expectedHeaderText.indexOf(key);
            if (index == -1) continue;
            int indexEnd = index + section.getKey().length();
            for (Map.Entry entry : sectionsByIndex.entrySet()) {
                int existingIndexStart = (Integer)entry.getKey();
                HeaderSection existingSection = (HeaderSection)entry.getValue();
                int existingIndexEnd = existingIndexStart + existingSection.getKey().length();
                if (existingIndexStart < indexEnd && index < existingIndexEnd) {
                    throw new IllegalArgumentException(String.format("Existing section '%1$s' overlaps with new section '%2$s'", existingSection.getKey(), section.getKey()));
                }
                sectionsByIndex.put(index, section);
            }
            sectionsByIndex.put(index, section);
        }
        return sectionsByIndex;
    }

    private List<String> buildExpectedTextBetweenSections(String expectedHeaderText, SortedMap<Integer, HeaderSection> sectionsByIndex) {
        ArrayList<String> textBetweenSections = new ArrayList<String>();
        int currentIndex = 0;
        for (Map.Entry<Integer, HeaderSection> entry : sectionsByIndex.entrySet()) {
            int index = entry.getKey();
            HeaderSection section = entry.getValue();
            String textBetween = expectedHeaderText.substring(currentIndex, index);
            textBetweenSections.add(textBetween);
            currentIndex = index + section.getKey().length();
        }
        String textBetween = expectedHeaderText.substring(currentIndex, expectedHeaderText.length());
        textBetweenSections.add(textBetween);
        return textBetweenSections;
    }

    private boolean recursivelyFindMatch(String potentialFileHeader, HeaderDefinition headerDefinition, List<String> expectedTextBetweenSections, List<HeaderSection> sectionsInOrder, int currentTextSegmentIndex, int currentPotentialFileHeaderIndex) {
        if (currentTextSegmentIndex == expectedTextBetweenSections.size()) {
            return true;
        }
        int currentSearchFromIndex = currentPotentialFileHeaderIndex;
        String expectedText;
        int index;
        while ((index = potentialFileHeader.indexOf(expectedText = expectedTextBetweenSections.get(currentTextSegmentIndex), currentSearchFromIndex)) != -1) {
            String sectionValue;
            HeaderSection section;
            if (currentTextSegmentIndex > 0 && !this.ensureSectionMatch(headerDefinition, section = sectionsInOrder.get(currentTextSegmentIndex - 1), sectionValue = potentialFileHeader.substring(currentPotentialFileHeaderIndex, index))) {
                return false;
            }
            if (this.recursivelyFindMatch(potentialFileHeader, headerDefinition, expectedTextBetweenSections, sectionsInOrder, currentTextSegmentIndex + 1, index + expectedText.length())) {
                return true;
            }
            currentSearchFromIndex = index + 1;
        }
        return false;
    }

    private boolean ensureSectionMatch(HeaderDefinition headerDefinition, HeaderSection section, String sectionValue) {
        String match = section.getEnsureMatch();
        if (!this.notEmpty(match)) {
            return true;
        }
        String[] lines = sectionValue.split("\n");
        String before = headerDefinition.getBeforeEachLine();
        if (this.notEmpty(before)) {
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (!line.startsWith(before)) continue;
                lines[i] = line.substring(before.length());
            }
        }
        if (section.isMultiLineMatch()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < lines.length; ++i) {
                if (i > 0) {
                    b.append('\n');
                }
                b.append(lines[i]);
            }
            String multiLineValue = b.toString();
            return multiLineValue.matches(match);
        }
        for (String line : lines) {
            if (line.matches(match)) continue;
            return false;
        }
        return true;
    }
}

