/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openehr.bmm.core.BmmDefinedType;
import org.openehr.bmm.core.BmmEntity;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmSimpleClass;
import org.openehr.bmm.core.BmmType;

public abstract class BmmClass
extends BmmEntity
implements Serializable {
    private String name;
    private Map<String, BmmDefinedType> ancestors = new LinkedHashMap<String, BmmDefinedType>();
    private BmmPackage bmmPackage;
    private BmmModel bmmModel;
    private Map<String, BmmProperty<?>> properties = new LinkedHashMap();
    private String sourceSchemaId;
    private List<String> immediateDescendants = new ArrayList<String>();
    private boolean isAbstract;
    private boolean isPrimitiveType;
    private boolean isOverride;

    public BmmClass(String aName, String aDocumentation, boolean abstractFlag) {
        this.name = aName;
        this.setDocumentation(aDocumentation);
        this.isAbstract = abstractFlag;
    }

    public BmmClass() {
    }

    public String getName() {
        return this.name;
    }

    public abstract BmmDefinedType getType();

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, BmmDefinedType> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(Map<String, BmmDefinedType> ancestors) {
        this.ancestors = ancestors;
    }

    public void addAncestor(BmmDefinedType ancestor) {
        this.ancestors.put(ancestor.getTypeName(), ancestor);
    }

    public BmmPackage getPackage() {
        return this.bmmPackage;
    }

    public void setPackage(BmmPackage bmmPackage) {
        this.bmmPackage = bmmPackage;
    }

    public Map<String, BmmProperty<?>> getProperties() {
        return this.properties;
    }

    public Map<String, BmmProperty<?>> getFlatProperties() {
        LinkedHashMap result = new LinkedHashMap();
        this.getAncestors().forEach((ancestorName, ancestor) -> result.putAll(ancestor.getBaseClass().getFlatProperties()));
        result.putAll(this.properties);
        return result;
    }

    public void setProperties(Map<String, BmmProperty<?>> properties) {
        this.properties = properties;
    }

    public void addProperty(BmmProperty<?> property) {
        this.properties.put(property.getName(), property);
    }

    public String getSourceSchemaId() {
        return this.sourceSchemaId;
    }

    public void setSourceSchemaId(String sourceSchemaId) {
        this.sourceSchemaId = sourceSchemaId;
    }

    public List<String> getImmediateDescendants() {
        return this.immediateDescendants;
    }

    public void setImmediateDescendants(List<String> immediateDescendants) {
        this.immediateDescendants = immediateDescendants;
    }

    public void addImmediateDescendant(String immediateDescendant) {
        this.immediateDescendants.add(immediateDescendant);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public boolean isPrimitiveType() {
        return this.isPrimitiveType;
    }

    public void setPrimitiveType(boolean primitiveType) {
        this.isPrimitiveType = primitiveType;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean override) {
        this.isOverride = override;
    }

    public List<String> findAllAncestors() {
        Map<String, BmmDefinedType> ancestors = this.getAncestors();
        ArrayList<String> result = new ArrayList<String>(ancestors.keySet());
        for (BmmDefinedType ancestor : ancestors.values()) {
            result.addAll(ancestor.getBaseClass().findAllAncestors());
        }
        return result;
    }

    public List<String> findAllDescendants() {
        List<String> descendants = this.getImmediateDescendants();
        ArrayList<String> result = new ArrayList<String>(descendants);
        for (String descendant : descendants) {
            BmmClass classDefinition = this.getBmmModel().getClassDefinition(descendant);
            if (classDefinition == null) continue;
            result.addAll(classDefinition.findAllDescendants());
        }
        return result;
    }

    public List<String> findSuppliers() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<String> findSuppliersNonPrimitive() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<String> findSupplierClosure() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getPackagePath() {
        return this.bmmPackage == null ? null : this.bmmPackage.getPath();
    }

    public String getClassPath() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BmmPackage getBmmPackage() {
        return this.bmmPackage;
    }

    public void setBmmPackage(BmmPackage bmmPackage) {
        this.bmmPackage = bmmPackage;
    }

    public BmmModel getBmmModel() {
        return this.bmmModel;
    }

    public void setBmmModel(BmmModel bmmModel) {
        this.bmmModel = bmmModel;
    }

    public String effectivePropertyType(String propertyName) {
        BmmProperty<?> property = this.getFlatProperties().get(propertyName);
        return property == null ? "UNKNOWN" : ((BmmType)property.getType()).getTypeName();
    }

    public BmmClass duplicate() {
        BmmClass result = this instanceof BmmGenericClass ? new BmmGenericClass(this.getName(), this.getDocumentation(), this.isAbstract) : new BmmSimpleClass(this.getName(), this.getDocumentation(), this.isAbstract);
        result.getProperties().putAll(this.getProperties());
        result.setSourceSchemaId(this.getSourceSchemaId());
        result.getAncestors().putAll(this.getAncestors());
        result.setImmediateDescendants(this.getImmediateDescendants());
        result.setOverride(this.isOverride);
        result.setPrimitiveType(this.isPrimitiveType);
        result.setPackage(this.getPackage());
        result.setBmmModel(this.getBmmModel());
        return result;
    }

    public Boolean hasPropertyWithName(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public Boolean hasFlatPropertyWithName(String propertyName) {
        return this.getFlatProperties().containsKey(propertyName);
    }

    public String toString() {
        return this.name;
    }
}

