/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openehr.bmm.core.BmmDefinedType;
import org.openehr.bmm.core.BmmEffectiveType;
import org.openehr.bmm.core.BmmSimpleType;
import org.openehr.bmm.core.BmmUnitaryType;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class BmmParameterType
extends BmmUnitaryType
implements Serializable {
    private String name;
    private BmmEffectiveType conformsToType;
    private BmmParameterType inheritancePrecursor;
    private BmmDefinedType anyTypeDefinition;

    public BmmParameterType(String aName, BmmSimpleType anAnyType) {
        this.name = aName;
        this.anyTypeDefinition = anAnyType;
    }

    public BmmParameterType(String aName, BmmDefinedType aConformsToType, BmmSimpleType anAnyType) {
        this.name = aName;
        this.anyTypeDefinition = anAnyType;
        this.conformsToType = aConformsToType;
    }

    public BmmParameterType() {
    }

    @Override
    public String getTypeName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BmmEffectiveType getConformsToType() {
        return this.conformsToType;
    }

    public void setConformsToType(BmmEffectiveType conformsToType) {
        this.conformsToType = conformsToType;
    }

    public BmmParameterType getInheritancePrecursor() {
        return this.inheritancePrecursor;
    }

    public void setInheritancePrecursor(BmmParameterType inheritancePrecursor) {
        this.inheritancePrecursor = inheritancePrecursor;
    }

    public BmmEffectiveType flattenedConformsToType() {
        if (this.conformsToType != null) {
            return this.conformsToType;
        }
        if (this.inheritancePrecursor != null) {
            return this.inheritancePrecursor.flattenedConformsToType();
        }
        return null;
    }

    @Override
    public BmmEffectiveType getEffectiveType() {
        BmmEffectiveType confType = this.flattenedConformsToType();
        if (confType != null) {
            return confType;
        }
        return this.anyTypeDefinition;
    }

    @Override
    public String getTypeSignature() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        BmmEffectiveType confType = this.flattenedConformsToType();
        if (confType != null) {
            builder.append(BmmDefinitions.GENERIC_CONSTRAINT_DELIMITER + confType.getTypeName());
        }
        return builder.toString();
    }

    @Override
    public List<String> getFlattenedTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        BmmEffectiveType confType = this.flattenedConformsToType();
        if (confType != null) {
            result.addAll(confType.getFlattenedTypeList());
        } else {
            result.add("Any");
        }
        return result;
    }

    @Override
    public String toDisplayString() {
        return null;
    }
}

