/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openehr.bmm.core.IBmmSchemaCore;
import org.openehr.bmm.persistence.validation.BmmDefinitions;

public class BmmSchemaCore
implements IBmmSchemaCore,
Serializable {
    private String rmPublisher;
    private String rmRelease;
    private String schemaName;
    private String schemaRevision;
    private String schemaLifecycleState;
    private String schemaAuthor;
    private String schemaDescription;
    private List<String> schemaContributors = new ArrayList<String>();
    private String archetypeParentClass;
    private String archetypeDataValueParentClass;
    private List<String> archetypeRmClosurePackages = new ArrayList<String>();
    private String archetypeVisualizeDescendantsOf;
    private String modelName;

    public BmmSchemaCore() {
    }

    public BmmSchemaCore(String aRmPublisher, String aSchemaName, String aRmRelease) {
        this();
        this.rmPublisher = aRmPublisher;
        this.schemaName = aSchemaName;
        this.rmRelease = aRmRelease;
    }

    @Override
    public String getRmPublisher() {
        return this.rmPublisher;
    }

    @Override
    public void setRmPublisher(String rmPublisher) {
        this.rmPublisher = rmPublisher;
    }

    @Override
    public String getRmRelease() {
        return this.rmRelease;
    }

    @Override
    public void setRmRelease(String rmRelease) {
        this.rmRelease = rmRelease;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchemaRevision() {
        return this.schemaRevision;
    }

    @Override
    public void setSchemaRevision(String schemaRevision) {
        this.schemaRevision = schemaRevision;
    }

    @Override
    public String getSchemaLifecycleState() {
        return this.schemaLifecycleState;
    }

    @Override
    public void setSchemaLifecycleState(String schemaLifecycleState) {
        this.schemaLifecycleState = schemaLifecycleState;
    }

    @Override
    public String getSchemaAuthor() {
        return this.schemaAuthor;
    }

    @Override
    public void setSchemaAuthor(String schemaAuthor) {
        this.schemaAuthor = schemaAuthor;
    }

    @Override
    public String getSchemaDescription() {
        return this.schemaDescription;
    }

    @Override
    public void setSchemaDescription(String schemaDescription) {
        this.schemaDescription = schemaDescription;
    }

    @Override
    public List<String> getSchemaContributors() {
        return this.schemaContributors;
    }

    @Override
    public void setSchemaContributors(List<String> schemaContributors) {
        this.schemaContributors = schemaContributors;
    }

    public boolean hasSchemaContributor(String aSchemaContributor) {
        return this.schemaContributors.contains(aSchemaContributor);
    }

    public void addSchemaContributor(String aContributor) {
        this.schemaContributors.add(aContributor);
    }

    @Override
    public String getArchetypeParentClass() {
        return this.archetypeParentClass;
    }

    public boolean hasArchetypeParentClass() {
        return this.archetypeParentClass != null;
    }

    @Override
    public void setArchetypeParentClass(String archetypeParentClass) {
        this.archetypeParentClass = archetypeParentClass;
    }

    @Override
    public String getArchetypeDataValueParentClass() {
        return this.archetypeDataValueParentClass;
    }

    public boolean hasArchetypeDataValueParentClass() {
        return this.archetypeDataValueParentClass != null;
    }

    @Override
    public void setArchetypeDataValueParentClass(String archetypeDataValueParentClass) {
        this.archetypeDataValueParentClass = archetypeDataValueParentClass;
    }

    @Override
    public List<String> getArchetypeRmClosurePackages() {
        return this.archetypeRmClosurePackages;
    }

    @Override
    public void setArchetypeRmClosurePackages(List<String> rmClosurePackages) {
        this.archetypeRmClosurePackages = rmClosurePackages;
    }

    @Override
    public void addArchetypeRmClosurePackage(String rmClosurePackage) {
        this.archetypeRmClosurePackages.add(rmClosurePackage);
    }

    public boolean hasArchetypeRmClosurePackage(String rmClosurePackage) {
        return this.archetypeRmClosurePackages.contains(rmClosurePackage);
    }

    @Override
    public String getArchetypeVisualizeDescendantsOf() {
        return this.archetypeVisualizeDescendantsOf;
    }

    @Override
    public void setArchetypeVisualizeDescendantsOf(String archetypeVisualizeDescendantsOf) {
        this.archetypeVisualizeDescendantsOf = archetypeVisualizeDescendantsOf;
    }

    @Override
    public String getSchemaId() {
        return BmmDefinitions.createSchemaId(this.getRmPublisher(), this.getSchemaName(), this.getRmRelease());
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

