/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.persistence.validation;

import java.util.Date;
import java.util.regex.Pattern;

public class BasicDefinitions {
    public static final String ANY_TYPE = "Any";
    public static final String TERMINOLOGY_SEPARATOR = "::";
    public static final String REGEX_ANY_PATTERN = ".*";
    public static final Character CR = Character.valueOf('\r');
    public static final Character LF = Character.valueOf('\n');
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final Character UTF8_BOM_CHAR_1 = Character.valueOf('\u00ef');
    public static final Character UTF8_BOM_CHAR_2 = Character.valueOf('\u00bb');
    public static final Character UTF8_BOM_CHAR_3 = Character.valueOf('\u00bf');
    public static final Integer UTF8_BOM_LENGTH = 3;
    public static final Character UTF8_COPYRIGHT_CHAR = Character.valueOf('\u00a9');
    public static final Date timeEpoch = new Date(0L);
    public static final String STANDARD_VERSION_REGEX = "[0-9]+(\\.[0-9]+){0,2}";
    public static final Pattern STANDARD_VERSION_REGEX_PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+){0,2}");

    public static String bareTypeName(String typeString) {
        if (typeString.charAt(0) == '!') {
            return typeString.substring(1);
        }
        return typeString;
    }

    public static String formatReal(Double real) {
        return real.toString();
    }

    public static boolean versionLessThan(String lver, String rver) {
        if (!BasicDefinitions.isValidStandardVersion(lver) || !BasicDefinitions.isValidStandardVersion(rver)) {
            throw new IllegalArgumentException("Invalid version argument " + lver + "," + rver);
        }
        String[] lverString = lver.split("\\.");
        String[] rverString = rver.split("\\.");
        boolean retVal = false;
        for (int index = 0; index <= 3; ++index) {
            int rvalue;
            int lvalue = Integer.parseInt(lverString[index]);
            if (lvalue < (rvalue = Integer.parseInt(rverString[index]))) {
                retVal = true;
                break;
            }
            if (lvalue != rvalue) break;
        }
        return retVal;
    }

    public static boolean isValidStandardVersion(String version) {
        return STANDARD_VERSION_REGEX_PATTERN.matcher(version).matches();
    }
}

