/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmDefinedType;
import org.openehr.bmm.core.BmmGenericClass;
import org.openehr.bmm.core.BmmProperty;
import org.openehr.bmm.core.BmmSimpleClass;
import org.openehr.bmm.core.BmmType;
import org.openehr.bmm.v2.persistence.PBmmBase;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmGenericType;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;
import org.openehr.bmm.v2.validation.converters.BmmClassProcessor;

public class PBmmClass
extends PBmmBase {
    private String documentation;
    private String name;
    private List<String> ancestors;
    private Map<String, PBmmUnitaryType> ancestorDefs;
    private Map<String, PBmmProperty<?>> properties;
    private Boolean isAbstract;
    private Map<String, PBmmGenericParameter> genericParameterDefs;
    private Boolean isOverride;
    private transient String sourceSchemaId;

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAncestors() {
        if (this.ancestors == null) {
            this.ancestors = new ArrayList<String>();
        }
        return this.ancestors;
    }

    @JsonIgnore
    public Map<String, PBmmUnitaryType> ancestorRefs(PBmmSchema schema) {
        if (this.ancestorDefs != null) {
            return this.ancestorDefs;
        }
        LinkedHashMap<String, PBmmUnitaryType> result = new LinkedHashMap<String, PBmmUnitaryType>();
        if (this.ancestors != null) {
            for (String anc : this.ancestors) {
                PBmmClass pBmmClass = schema.getClassDefinition(anc);
                if (pBmmClass != null) {
                    if (pBmmClass.isGeneric()) {
                        result.put(anc, new PBmmGenericType(anc, new ArrayList<String>(pBmmClass.genericParameterDefs.keySet())));
                        continue;
                    }
                    result.put(anc, new PBmmSimpleType(anc));
                    continue;
                }
                throw new RuntimeException("Error retrieving class definition for ancestor \"" + anc + "\" of PBmmClass " + this.name);
            }
        }
        return result;
    }

    @JsonIgnore
    public List<String> getAncestorTypeNames() {
        if (this.ancestorDefs != null && !this.ancestorDefs.isEmpty()) {
            return this.ancestorDefs.values().stream().map(type -> type.asTypeString()).collect(Collectors.toList());
        }
        if (this.ancestors != null) {
            return this.ancestors;
        }
        return new ArrayList<String>();
    }

    public void setAncestors(List<String> ancestors) {
        this.ancestors = ancestors;
    }

    public Map<String, PBmmProperty<?>> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties;
    }

    public void setProperties(Map<String, PBmmProperty<?>> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="is_abstract")
    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    @JsonProperty(value="is_override")
    public Boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(Boolean override) {
        this.isOverride = override;
    }

    public Map<String, PBmmGenericParameter> getGenericParameterDefs() {
        if (this.genericParameterDefs == null) {
            this.genericParameterDefs = new LinkedHashMap<String, PBmmGenericParameter>();
        }
        return this.genericParameterDefs;
    }

    public void setGenericParameterDefs(Map<String, PBmmGenericParameter> genericParameterDefs) {
        this.genericParameterDefs = genericParameterDefs;
    }

    @JsonIgnore
    public boolean isGeneric() {
        return this.getGenericParameterDefs() != null && this.getGenericParameterDefs().size() > 0;
    }

    @JsonIgnore
    public String getSourceSchemaId() {
        return this.sourceSchemaId;
    }

    public void setSourceSchemaId(String sourceSchemaId) {
        this.sourceSchemaId = sourceSchemaId;
    }

    public Map<String, PBmmUnitaryType> getAncestorDefs() {
        return this.ancestorDefs;
    }

    public BmmClass createBmmClass() {
        BmmClass bmmClass = this.getGenericParameterDefs().size() > 0 ? new BmmGenericClass(this.getName(), this.getDocumentation(), this.nullToFalse(this.isAbstract())) : new BmmSimpleClass(this.getName(), this.getDocumentation(), this.nullToFalse(this.isAbstract()));
        bmmClass.setOverride(this.nullToFalse(this.isOverride()));
        bmmClass.setSourceSchemaId(this.getSourceSchemaId());
        return bmmClass;
    }

    public BmmClass populateBmmClass(BmmClassProcessor classProcessor, PBmmSchema schema) {
        BmmClass bmmClass = classProcessor.getUnprocessedClassDefinition(this.getName());
        if (bmmClass != null) {
            for (PBmmUnitaryType ancestorType : this.ancestorRefs(schema).values()) {
                BmmClass ancestorClass = classProcessor.getClassDefinition(ancestorType.baseType());
                if (ancestorClass == null) {
                    throw new RuntimeException("Error retrieving class definition for ancestor class " + ancestorType.baseType() + " of BmmClass " + this.name);
                }
                BmmType bmmType = ancestorType.createBmmType(classProcessor, ancestorClass);
                if (bmmType instanceof BmmDefinedType) {
                    bmmClass.addAncestor((BmmDefinedType)bmmType);
                    continue;
                }
                throw new RuntimeException("Ancestor class definition of the wrong type for ancestor class " + ancestorType.baseType() + " of BmmClass " + this.name);
            }
            if (bmmClass instanceof BmmGenericClass) {
                for (PBmmGenericParameter param : this.getGenericParameterDefs().values()) {
                    ((BmmGenericClass)bmmClass).addGenericParameter(param.createBmmGenericParameter(classProcessor));
                }
            }
        } else {
            throw new RuntimeException("bmmClass for PBmmClass \"" + this.name + "\" is null. It may have been defined as a class or a primitive but not included in a package");
        }
        return bmmClass;
    }

    public BmmClass populateBmmClassProperties(BmmClassProcessor classProcessor) {
        BmmClass bmmClass = classProcessor.getUnprocessedClassDefinition(this.getName());
        if (bmmClass != null) {
            for (PBmmProperty<?> pBmmProperty : this.getProperties().values()) {
                BmmProperty<?> bmmProperty = pBmmProperty.createBmmProperty(classProcessor, bmmClass);
                if (bmmProperty != null) {
                    bmmClass.addProperty(bmmProperty);
                    continue;
                }
                throw new RuntimeException("BMM Property creation returned null");
            }
        }
        return bmmClass;
    }
}

