/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.openehr.bmm.v2.persistence.CaseInsensitiveLinkedHashMap;
import org.openehr.bmm.v2.persistence.PBmmPackageContainer;

public final class PBmmPackage
extends PBmmPackageContainer {
    private String documentation;
    private String name;
    private List<String> classes;

    public PBmmPackage() {
    }

    public PBmmPackage(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<String>();
        }
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public void setClassesAndPackagesFrom(PBmmPackage other) {
        this.setClasses(new ArrayList<String>(other.getClasses()));
        CaseInsensitiveLinkedHashMap<PBmmPackage> packages = new CaseInsensitiveLinkedHashMap<PBmmPackage>();
        packages.putAll(other.getPackages());
        this.setPackages(packages);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void doRecursiveClasses(BiConsumer<PBmmPackage, String> action) {
        this.getClasses().forEach(bmmClass -> action.accept(this, (String)bmmClass));
        this.getPackages().forEach((key, bmmPackage) -> bmmPackage.doRecursiveClasses(action));
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

