/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.BmmIncludeSpec;
import org.openehr.bmm.v2.persistence.CaseInsensitiveLinkedHashMap;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmPackageContainer;

@JsonPropertyOrder(value={"bmm_version", "rm_publisher", "schema_name", "rm_release", "model_name", "schema_revision", "schema_lifecycle_state", "schema_description", "schema_author", "archetype_closure_packages", "archetype_parent_class", "archetype_data_value_parent_class", "archetype_visualize_descendants_of", "includes", "packages", "primitive_types", "class_definitions"})
public final class PBmmSchema
extends PBmmPackageContainer {
    private Map<String, PBmmClass> primitiveTypes;
    private Map<String, PBmmClass> classDefinitions;
    private Map<String, BmmIncludeSpec> includes;
    private String rmPublisher;
    private String rmRelease;
    private String bmmVersion;
    private String modelName;
    private String schemaName;
    private String schemaRevision;
    private String schemaLifecycleState;
    private String schemaAuthor;
    private String schemaDescription;
    private List<String> schemaContributors;
    @Deprecated
    private List<String> archetypeRmClosurePackages;
    @Deprecated
    private String archetypeParentClass;
    @Deprecated
    private String archetypeDataValueParentClass;
    @Deprecated
    private String archetypeVisualizeDescendantsOf;

    public Map<String, PBmmClass> getPrimitiveTypes() {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = new CaseInsensitiveLinkedHashMap<PBmmClass>();
        }
        return this.primitiveTypes;
    }

    public void setPrimitiveTypes(Map<String, PBmmClass> primitiveTypes) {
        this.primitiveTypes = primitiveTypes;
    }

    public Map<String, PBmmClass> getClassDefinitions() {
        if (this.classDefinitions == null) {
            this.classDefinitions = new CaseInsensitiveLinkedHashMap<PBmmClass>();
        }
        return this.classDefinitions;
    }

    public void setClassDefinitions(Map<String, PBmmClass> classDefinitions) {
        this.classDefinitions = classDefinitions;
    }

    public Map<String, BmmIncludeSpec> getIncludes() {
        if (this.includes == null) {
            this.includes = new CaseInsensitiveLinkedHashMap<BmmIncludeSpec>();
        }
        return this.includes;
    }

    public void setIncludes(Map<String, BmmIncludeSpec> includes) {
        this.includes = includes;
    }

    public String getBmmVersion() {
        return this.bmmVersion;
    }

    public void setBmmVersion(String bmmVersion) {
        this.bmmVersion = bmmVersion;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaRevision() {
        return this.schemaRevision;
    }

    public void setSchemaRevision(String schemaRevision) {
        this.schemaRevision = schemaRevision;
    }

    public String getSchemaLifecycleState() {
        return this.schemaLifecycleState;
    }

    public void setSchemaLifecycleState(String schemaLifecycleState) {
        this.schemaLifecycleState = schemaLifecycleState;
    }

    public String getSchemaAuthor() {
        return this.schemaAuthor;
    }

    public void setSchemaAuthor(String schemaAuthor) {
        this.schemaAuthor = schemaAuthor;
    }

    public String getSchemaDescription() {
        return this.schemaDescription;
    }

    public void setSchemaDescription(String schemaDescription) {
        this.schemaDescription = schemaDescription;
    }

    public List<String> getSchemaContributors() {
        return this.schemaContributors;
    }

    public void setSchemaContributors(List<String> schemaContributors) {
        this.schemaContributors = schemaContributors;
    }

    public String getRmPublisher() {
        return this.rmPublisher;
    }

    public void setRmPublisher(String rmPublisher) {
        this.rmPublisher = rmPublisher;
    }

    public String getRmRelease() {
        return this.rmRelease;
    }

    public void setRmRelease(String rmRelease) {
        this.rmRelease = rmRelease;
    }

    @Deprecated
    public List<String> getArchetypeRmClosurePackages() {
        if (this.archetypeRmClosurePackages == null) {
            this.archetypeRmClosurePackages = new ArrayList<String>();
        }
        return this.archetypeRmClosurePackages;
    }

    @Deprecated
    public void setArchetypeRmClosurePackages(List<String> archetypeRmClosurePackages) {
        this.archetypeRmClosurePackages = archetypeRmClosurePackages;
    }

    public String getArchetypeParentClass() {
        return this.archetypeParentClass;
    }

    public void setArchetypeParentClass(String archetypeParentClass) {
        this.archetypeParentClass = archetypeParentClass;
    }

    public String getArchetypeDataValueParentClass() {
        return this.archetypeDataValueParentClass;
    }

    public void setArchetypeDataValueParentClass(String archetypeDataValueParentClass) {
        this.archetypeDataValueParentClass = archetypeDataValueParentClass;
    }

    @JsonAlias(value={"archetype_visualise_descendants_of"})
    public String getArchetypeVisualizeDescendantsOf() {
        return this.archetypeVisualizeDescendantsOf;
    }

    public void setArchetypeVisualizeDescendantsOf(String archetypeVisualizeDescendantsOf) {
        this.archetypeVisualizeDescendantsOf = archetypeVisualizeDescendantsOf;
    }

    @JsonIgnore
    public String getSchemaId() {
        return BmmDefinitions.createSchemaId(this.getRmPublisher(), this.getSchemaName(), this.getRmRelease());
    }

    public boolean hasClassOrPrimitiveDefinition(String persistedBmmClass) {
        return this.getClassDefinitions().containsKey(persistedBmmClass) || this.getPrimitiveTypes().containsKey(persistedBmmClass);
    }

    public PBmmClass getClassDefinition(String className) {
        PBmmClass result = this.classDefinitions.get(className);
        if (result == null) {
            result = this.primitiveTypes.get(className);
        }
        return result;
    }

    public void doAllClasses(Consumer<PBmmClass> action) {
        this.getPrimitiveTypes().values().forEach(action);
        this.getClassDefinitions().values().forEach(action);
    }
}

