/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.nedap.archie.base.OpenEHRBase;
import java.io.IOException;
import org.openehr.bmm.v2.persistence.jackson.BmmTypeNaming;

public class BmmJacksonUtil {
    private static volatile ObjectMapper objectMapper;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            BmmJacksonUtil.configureObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    public static void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        objectMapper.enable(new MapperFeature[]{MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL});
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
                if (propertyName.equalsIgnoreCase("_type")) {
                    return true;
                }
                return super.handleUnknownProperty(ctxt, p, deserializer, beanOrClass, propertyName);
            }
        });
        StdTypeResolverBuilder typeResolverBuilder = new BmmTypeResolverBuilder().init(JsonTypeInfo.Id.NAME, (TypeIdResolver)new BmmTypeNaming()).typeProperty("_type").typeIdVisibility(true).inclusion(JsonTypeInfo.As.PROPERTY);
        objectMapper.setDefaultTyping((TypeResolverBuilder)typeResolverBuilder);
    }

    static class BmmTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        public BmmTypeResolverBuilder() {
            super(ObjectMapper.DefaultTyping.NON_FINAL, (PolymorphicTypeValidator)BasicPolymorphicTypeValidator.builder().allowIfBaseType(OpenEHRBase.class).build());
        }

        public boolean useForType(JavaType t) {
            return OpenEHRBase.class.isAssignableFrom(t.getRawClass()) && super.useForType(t);
        }
    }
}

