/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.persistence.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableBiMap;
import com.nedap.archie.base.Interval;
import com.nedap.archie.base.OpenEHRBase;
import java.io.IOException;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.BmmIncludeSpec;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmContainerProperty;
import org.openehr.bmm.v2.persistence.PBmmContainerType;
import org.openehr.bmm.v2.persistence.PBmmEnumeration;
import org.openehr.bmm.v2.persistence.PBmmEnumerationInteger;
import org.openehr.bmm.v2.persistence.PBmmEnumerationString;
import org.openehr.bmm.v2.persistence.PBmmGenericParameter;
import org.openehr.bmm.v2.persistence.PBmmGenericProperty;
import org.openehr.bmm.v2.persistence.PBmmGenericType;
import org.openehr.bmm.v2.persistence.PBmmOpenType;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmProperty;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.persistence.PBmmSimpleType;
import org.openehr.bmm.v2.persistence.PBmmSingleProperty;
import org.openehr.bmm.v2.persistence.PBmmSinglePropertyOpen;
import org.openehr.bmm.v2.persistence.PBmmType;
import org.openehr.bmm.v2.persistence.PBmmUnitaryType;

public class BmmTypeNaming
extends ClassNameIdResolver {
    private static final ImmutableBiMap<String, Class<?>> classNaming = ImmutableBiMap.builder().put((Object)"BMM_INCLUDE_SPEC", BmmIncludeSpec.class).put((Object)"P_BMM_CLASS", PBmmClass.class).put((Object)"P_BMM_CONTAINER_PROPERTY", PBmmContainerProperty.class).put((Object)"P_BMM_ENUMERATION", PBmmEnumeration.class).put((Object)"P_BMM_ENUMERATION_STRING", PBmmEnumerationString.class).put((Object)"P_BMM_ENUMERATION_INTEGER", PBmmEnumerationInteger.class).put((Object)"P_BMM_GENERIC_PARAMETER", PBmmGenericParameter.class).put((Object)"P_BMM_GENERIC_PROPERTY", PBmmGenericProperty.class).put((Object)"P_BMM_GENERIC_TYPE", PBmmGenericType.class).put((Object)"P_BMM_OPEN_TYPE", PBmmOpenType.class).put((Object)"P_BMM_CONTAINER_TYPE", PBmmContainerType.class).put((Object)"P_BMM_PACKAGE", PBmmPackage.class).put((Object)"P_BMM_PROPERTY", PBmmProperty.class).put((Object)"P_BMM_SCHEMA", PBmmSchema.class).put((Object)"P_BMM_SIMPLE_TYPE", PBmmSimpleType.class).put((Object)"P_BMM_SINGLE_PROPERTY", PBmmSingleProperty.class).put((Object)"P_BMM_SINGLE_PROPERTY_OPEN", PBmmSinglePropertyOpen.class).put((Object)"P_BMM_UNITARY_TYPE", PBmmUnitaryType.class).put((Object)"P_BMM_TYPE", PBmmType.class).put((Object)"INTERVAL", Interval.class).build();
    private static final ImmutableBiMap<Class<?>, String> inverseClassNaming = classNaming.inverse();

    protected BmmTypeNaming() {
        super(TypeFactory.defaultInstance().constructType(OpenEHRBase.class), TypeFactory.defaultInstance());
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    public String idFromValue(Object value) {
        String result = (String)inverseClassNaming.get(value.getClass());
        if (result != null) {
            return result;
        }
        return value.getClass().getSimpleName();
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        return this._typeFromId(id, context);
    }

    protected JavaType _typeFromId(String typeName, DatabindContext ctxt) throws IOException {
        String classKey = BmmDefinitions.typeNameToClassKey(typeName);
        Class result = (Class)classNaming.get((Object)classKey);
        if (result != null) {
            TypeFactory typeFactory = ctxt == null ? this._typeFactory : ctxt.getTypeFactory();
            return typeFactory.constructSpecializedType(this._baseType, result);
        }
        return super._typeFromId(typeName, ctxt);
    }
}

