/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.ArrayList;
import org.openehr.bmm.core.BmmClass;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.core.BmmPackage;
import org.openehr.bmm.core.BmmPackageContainer;
import org.openehr.bmm.v2.persistence.PBmmClass;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;
import org.openehr.bmm.v2.validation.BmmValidationResult;
import org.openehr.bmm.v2.validation.converters.BmmClassProcessor;

public class BmmModelCreator {
    public BmmModel create(BmmValidationResult validationResult) {
        PBmmSchema schema = validationResult.getSchemaWithMergedIncludes();
        BmmModel model = new BmmModel();
        model.setRmPublisher(schema.getRmPublisher());
        model.setRmRelease(schema.getRmRelease());
        model.setModelName(schema.getModelName());
        model.setSchemaName(schema.getSchemaName());
        model.setSchemaRevision(schema.getSchemaRevision());
        model.setSchemaAuthor(schema.getSchemaAuthor());
        model.setSchemaDescription(schema.getSchemaDescription());
        model.setSchemaLifecycleState(schema.getSchemaLifecycleState());
        model.setSchemaContributors(schema.getSchemaContributors() == null ? new ArrayList<String>() : new ArrayList<String>(schema.getSchemaContributors()));
        for (PBmmPackage pBmmPackage2 : validationResult.getCanonicalPackages().values()) {
            BmmPackage bmmPackage = this.createBmmPackageDefinition(pBmmPackage2, null, null);
            model.addPackage(bmmPackage);
        }
        validationResult.getCanonicalPackages().forEach((packageName, pBmmPackage) -> this.convertPackage(model, schema, pBmmPackage.getName(), (PBmmPackage)((Object)pBmmPackage), model));
        model.setArchetypeParentClass(schema.getArchetypeParentClass());
        model.setArchetypeDataValueParentClass(schema.getArchetypeDataValueParentClass());
        model.setArchetypeVisualizeDescendantsOf(schema.getArchetypeVisualizeDescendantsOf());
        model.setArchetypeRmClosurePackages(schema.getArchetypeRmClosurePackages() == null ? new ArrayList<String>() : new ArrayList<String>(schema.getArchetypeRmClosurePackages()));
        BmmClassProcessor classSupplier = new BmmClassProcessor(model, schema, (pBmmClass, processor) -> pBmmClass.populateBmmClass((BmmClassProcessor)processor, schema));
        classSupplier.run();
        BmmClassProcessor propertySupplier = new BmmClassProcessor(model, schema, (pBmmClass, processor) -> pBmmClass.populateBmmClassProperties((BmmClassProcessor)processor));
        propertySupplier.run();
        return model;
    }

    private void convertPackage(BmmModel model, PBmmSchema schema, String packageName, PBmmPackage pBmmPackage, BmmPackageContainer bmmParentPackage) {
        BmmPackage bmmPackage = bmmParentPackage.getPackage(pBmmPackage.getName());
        pBmmPackage.getClasses().forEach(className -> {
            BmmClass bmmClass;
            PBmmClass pBmmClass = schema.getClassDefinition((String)className);
            if (pBmmClass != null && (bmmClass = pBmmClass.createBmmClass()) != null) {
                bmmClass.setPrimitiveType(schema.getPrimitiveTypes().containsKey(bmmClass.getName()));
                model.addClassDefinition(bmmClass, bmmPackage);
            }
        });
        pBmmPackage.getPackages().forEach((subPackageName, pBmmSubPackage) -> this.convertPackage(model, schema, packageName + "." + pBmmSubPackage.getName(), (PBmmPackage)((Object)pBmmSubPackage), bmmPackage));
    }

    private BmmPackage createBmmPackageDefinition(PBmmPackage p, PBmmPackage parent, BmmPackage parentPackageDefinition) {
        BmmPackage bmmPackageDefinition = new BmmPackage(p.getName());
        bmmPackageDefinition.setDocumentation(p.getDocumentation());
        if (parent != null) {
            bmmPackageDefinition.appendToPath(parent.getName());
            bmmPackageDefinition.setParent(parentPackageDefinition);
        }
        bmmPackageDefinition.appendToPath(p.getName());
        p.getPackages().values().forEach(childPackage -> {
            BmmPackage bmmChildPackageDefinition = this.createBmmPackageDefinition((PBmmPackage)((Object)childPackage), p, bmmPackageDefinition);
            bmmPackageDefinition.addPackage(bmmChildPackageDefinition);
        });
        return bmmPackageDefinition;
    }
}

