/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.bmm.v2.validation.converters;

import java.util.Map;
import java.util.TreeMap;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.persistence.PBmmPackage;
import org.openehr.bmm.v2.persistence.PBmmSchema;

public class CanonicalPackagesGenerator {
    public Map<String, PBmmPackage> generateCanonicalPackages(PBmmSchema schema) {
        TreeMap<String, PBmmPackage> canonicalPackages = new TreeMap<String, PBmmPackage>(String.CASE_INSENSITIVE_ORDER);
        PBmmPackage childPackage = null;
        for (PBmmPackage topPackage : schema.getPackages().values()) {
            if (topPackage.getName().indexOf(BmmDefinitions.PACKAGE_NAME_DELIMITER.charValue()) >= 0) {
                String[] packagePathComponents;
                Map<String, PBmmPackage> packageContainer = canonicalPackages;
                for (String packagePathComponent : packagePathComponents = topPackage.getName().split("\\.")) {
                    String childPackageKey = packagePathComponent.toUpperCase();
                    if (packageContainer.containsKey(childPackageKey)) {
                        childPackage = (PBmmPackage)((Object)packageContainer.get(childPackageKey));
                    } else {
                        childPackage = new PBmmPackage(packagePathComponent);
                        packageContainer.put(childPackageKey, childPackage);
                    }
                    packageContainer = childPackage.getPackages();
                }
                childPackage.setClassesAndPackagesFrom(topPackage);
                continue;
            }
            canonicalPackages.put(topPackage.getName().toUpperCase(), topPackage);
        }
        return canonicalPackages;
    }
}

