/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.changecontrol;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMProperty;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="VERSION", propOrder={"contribution", "commitAudit", "signature"})
public abstract class Version<Type>
extends RMObject {
    private ObjectRef<? extends ObjectId> contribution;
    @Nullable
    private String signature;
    @XmlElement(name="commit_audit")
    private AuditDetails commitAudit;

    public Version() {
    }

    public Version(AuditDetails commitAudit, ObjectRef<? extends ObjectId> contribution, @Nullable String signature) {
        this.contribution = contribution;
        this.signature = signature;
        this.commitAudit = commitAudit;
    }

    public ObjectRef<? extends ObjectId> getContribution() {
        return this.contribution;
    }

    public void setContribution(ObjectRef<? extends ObjectId> contribution) {
        this.contribution = contribution;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AuditDetails getCommitAudit() {
        return this.commitAudit;
    }

    public void setCommitAudit(AuditDetails commitAudit) {
        this.commitAudit = commitAudit;
    }

    public abstract ObjectVersionId getUid();

    public abstract ObjectVersionId getPrecedingVersionUid();

    public abstract Type getData();

    public abstract DvCodedText getLifecycleState();

    public abstract String getCanonicalForm();

    @RMProperty(value="is_branch")
    public abstract boolean isBranch();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.contribution, version.contribution) && Objects.equals(this.signature, version.signature) && Objects.equals(this.commitAudit, version.commitAudit);
    }

    public int hashCode() {
        return Objects.hash(this.contribution, this.signature, this.commitAudit);
    }

    @Invariant(value="Lifecycle_state_valid")
    public boolean lifecycleStateValid() {
        return InvariantUtil.belongsToTerminologyByGroupId(this.getLifecycleState(), "version lifecycle state");
    }
}

