/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.composition;

import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.Participation;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EVENT_CONTEXT", propOrder={"startTime", "endTime", "location", "setting", "otherContext", "healthCareFacility", "participations"})
public class EventContext
extends Pathable {
    @XmlElement(name="start_time")
    private DvDateTime startTime;
    @Nullable
    @XmlElement(name="end_time")
    private DvDateTime endTime;
    @Nullable
    private String location;
    private DvCodedText setting;
    @XmlElement(name="other_context")
    @Nullable
    private ItemStructure otherContext;
    @Nullable
    @XmlElement(name="health_care_facility")
    private PartyIdentified healthCareFacility;
    @Nullable
    private List<Participation> participations = new ArrayList<Participation>();

    public EventContext() {
    }

    public EventContext(DvDateTime startTime, DvCodedText setting) {
        this.startTime = startTime;
        this.setting = setting;
    }

    public EventContext(@Nullable PartyIdentified healthCareFacility, DvDateTime startTime, @Nullable DvDateTime endTime, @Nullable List<Participation> participations, @Nullable String location, DvCodedText setting, @Nullable ItemStructure otherContext) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.location = location;
        this.setting = setting;
        this.otherContext = otherContext;
        this.healthCareFacility = healthCareFacility;
        this.participations = participations;
    }

    public DvDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DvDateTime startTime) {
        this.startTime = startTime;
    }

    public DvDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DvDateTime endTime) {
        this.endTime = endTime;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public DvCodedText getSetting() {
        return this.setting;
    }

    public void setSetting(DvCodedText setting) {
        this.setting = setting;
    }

    public ItemStructure getOtherContext() {
        return this.otherContext;
    }

    public void setOtherContext(ItemStructure otherContext) {
        this.otherContext = otherContext;
        this.setThisAsParent(otherContext, "other_context");
    }

    public PartyIdentified getHealthCareFacility() {
        return this.healthCareFacility;
    }

    public void setHealthCareFacility(PartyIdentified healthCareFacility) {
        this.healthCareFacility = healthCareFacility;
    }

    public List<Participation> getParticipations() {
        return this.participations;
    }

    public void setParticipations(List<Participation> participations) {
        this.participations = participations;
    }

    public void addParticipation(Participation participation) {
        this.participations.add(participation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventContext that = (EventContext)o;
        return Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.location, that.location) && Objects.equals(this.setting, that.setting) && Objects.equals(this.otherContext, that.otherContext) && Objects.equals(this.healthCareFacility, that.healthCareFacility) && Objects.equals(this.participations, that.participations);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.location, this.setting, this.otherContext, this.healthCareFacility, this.participations);
    }

    @Invariant(value="Setting_valid")
    public boolean settingValid() {
        return InvariantUtil.belongsToTerminologyByGroupId(this.setting, "setting");
    }

    @Invariant(value="Participations_validity", ignored=true)
    public boolean participationsValid() {
        return InvariantUtil.nullOrNotEmpty(this.participations);
    }

    @Invariant(value="Location_validity")
    public boolean locationValid() {
        return InvariantUtil.nullOrNotEmpty(this.location);
    }
}

