/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.composition;

import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.support.identification.LocatableRef;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="INSTRUCTION_DETAILS", propOrder={"instructionId", "activityId", "wfDetails"})
public class InstructionDetails
extends Pathable {
    @XmlElement(name="instruction_id")
    private LocatableRef instructionId;
    @XmlElement(name="activity_id")
    private String activityId;
    @XmlElement(name="wf_details")
    @Nullable
    private ItemStructure wfDetails;

    public InstructionDetails() {
    }

    public InstructionDetails(LocatableRef instructionId, String activityId, @Nullable ItemStructure wfDetails) {
        this.instructionId = instructionId;
        this.activityId = activityId;
        this.wfDetails = wfDetails;
    }

    public LocatableRef getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(LocatableRef instructionId) {
        this.instructionId = instructionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ItemStructure getWfDetails() {
        return this.wfDetails;
    }

    public void setWfDetails(ItemStructure wfDetails) {
        this.wfDetails = wfDetails;
        this.setThisAsParent(wfDetails, "wf_details");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionDetails that = (InstructionDetails)o;
        return Objects.equals(this.instructionId, that.instructionId) && Objects.equals(this.activityId, that.activityId) && Objects.equals(this.wfDetails, that.wfDetails);
    }

    public int hashCode() {
        return Objects.hash(this.instructionId, this.activityId, this.wfDetails);
    }

    @Invariant(value="Activity_path_valid")
    public boolean actionArchetypeIdValid() {
        return InvariantUtil.nullOrNotEmpty(this.activityId);
    }
}

