/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.composition;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.composition.ContentItem;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SECTION", propOrder={"items"})
public class Section
extends ContentItem {
    @Nullable
    private List<ContentItem> items = new ArrayList<ContentItem>();

    public Section() {
    }

    public Section(String archetypeNodeId, DvText name, @Nullable List<ContentItem> items) {
        super(archetypeNodeId, name);
        this.items = items;
    }

    public Section(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, @Nullable List<ContentItem> items) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.items = items;
    }

    public List<ContentItem> getItems() {
        return this.items;
    }

    public void setItems(List<ContentItem> items) {
        this.items = items;
        this.setThisAsParent(items, "items");
    }

    public void addItem(ContentItem item) {
        this.items.add(item);
        this.setThisAsParent(item, "items");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Section section = (Section)o;
        return Objects.equals(this.items, section.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.items);
    }

    @Invariant(value="Items_valid", ignored=true)
    public boolean itemsValid() {
        return InvariantUtil.nullOrNotEmpty(this.items);
    }
}

