/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rm.datastructures;

import com.nedap.archie.rm.archetyped.Archetyped;
import com.nedap.archie.rm.archetyped.FeederAudit;
import com.nedap.archie.rm.archetyped.Link;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rm.datastructures.Item;
import com.nedap.archie.rm.datavalues.DataValue;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.SingleValuedDataValue;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rmutil.InvariantUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ELEMENT", propOrder={"value", "nullFlavour", "nullReason"})
@XmlRootElement(name="element")
public class Element
extends Item
implements SingleValuedDataValue<DataValue> {
    @Nullable
    private DataValue value;
    @Nullable
    @XmlElement(name="null_flavour")
    private DvCodedText nullFlavour;
    @Nullable
    @XmlElement(name="null_reason")
    private DvText nullReason;

    public Element() {
    }

    public Element(String archetypeNodeId, DvText name, @Nullable DataValue value) {
        super(archetypeNodeId, name);
        this.value = value;
    }

    public Element(@Nullable UIDBasedId uid, String archetypeNodeId, DvText name, @Nullable Archetyped archetypeDetails, @Nullable FeederAudit feederAudit, @Nullable List<Link> links, @Nullable Pathable parent, @Nullable String parentAttributeName, @Nullable DataValue value, @Nullable DvCodedText nullFlavour, DvText nullReason) {
        super(uid, archetypeNodeId, name, archetypeDetails, feederAudit, links, parent, parentAttributeName);
        this.value = value;
        this.nullFlavour = nullFlavour;
        this.nullReason = nullReason;
    }

    public DvCodedText getNullFlavour() {
        return this.nullFlavour;
    }

    public void setNullFlavour(DvCodedText nullFlavour) {
        this.nullFlavour = nullFlavour;
    }

    @Override
    public DataValue getValue() {
        return this.value;
    }

    @Override
    public void setValue(DataValue value) {
        this.value = value;
    }

    @Nullable
    public DvText getNullReason() {
        return this.nullReason;
    }

    public void setNullReason(@Nullable DvText nullReason) {
        this.nullReason = nullReason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Element element = (Element)o;
        return Objects.equals(this.value, element.value) && Objects.equals(this.nullFlavour, element.nullFlavour) && Objects.equals(this.nullReason, element.nullReason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.nullFlavour, this.nullReason);
    }

    @Invariant(value="Inv_null_flavour_indicated")
    public boolean nullFlavourIndicated() {
        return this.value == null ^ this.nullFlavour == null;
    }

    @Invariant(value="Inv_null_flavour_valid")
    public boolean nullFlavourValid() {
        return InvariantUtil.belongsToTerminologyByGroupId(this.nullFlavour, "null flavours");
    }

    @Invariant(value="Inv_null_reason_valid")
    public boolean nullReasonValid() {
        if (this.nullReason != null) {
            return this.value == null;
        }
        return true;
    }
}

